% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ampliseq.R
\name{write_annotated_ampliseq_amplicons}
\alias{write_annotated_ampliseq_amplicons}
\title{Write AmpliSeq amplicon informaiton into an annotated BED file}
\usage{
write_annotated_ampliseq_amplicons(
  df,
  bedFile,
  version = format(Sys.time(), "\%Y\%m\%d")
)
}
\arguments{
\item{df}{A \code{data.frame} containing following columns (names do not matter):
\enumerate{
  \item chrom (RefSeq IDs)
  \item chromStart (integer)
  \item chromEnd (integer)
  \item name (Amplicon IDs)
  \item score (A single value, \code{.})
  \item ID (in the format of \code{GENE_ID=$GENESYMBOL;EntrezGeneID=$EG_ID})
}}

\item{bedFile}{Character string, the output file}

\item{version}{Character string, a version number. By default, the current date is used.}
}
\value{
No return value, called for side effects (writes an annotated BED file).
}
\description{
Write AmpliSeq amplicon informaiton into an annotated BED file
}
\examples{
mydf <- data.frame(chrom=c("NM_000014", "NM_000015", "NM_000021"),
  chromStart=c(3316, 50, 1212),
  chromEnd=c(3421, 146, 1320),
  name=c("AMPL1384", "AMPL7195", "AMPL14470"),
  score=".",
  ID=c("GENE_ID=A2M;EntrezGeneID=2",
       "GENE_ID=NAT2;EntrezGeneID=10",
       "GENE_ID=PSEN1;EntrezGeneID=5663"))
myBed <- tempfile()  
write_annotated_ampliseq_amplicons(mydf, myBed)
mydfOut <- read_annotated_ampliseq_amplicons(myBed)
}
\seealso{
\code{\link{read_annotated_ampliseq_amplicons}}
}
