% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geedim-versions.R
\name{geedim-versions}
\alias{geedim-versions}
\title{Handling geedim 1.x.x and 2.x.x APIs}
\description{
rgeedim is designed to work with both geedim 1.x.x and 2.x.x.
}
\section{API Changes}{


\code{geedim} 2.0.0 introduced a number of breaking changes to the API. The most notable changes are:
\itemize{
\item The \code{MaskedImage} and \code{MaskedCollection} classes are deprecated. The \code{ee.Image.gd} and \code{ee.ImageCollection.gd} accessors should be used instead.
\item The default Landsat cloud mask is more aggressive.
\item \code{MaskedCollection.stac} property now returns a STAC dictionary and not a \code{StacItem} instance.
\item \code{MaskedImage} doesn't add mask bands to composite images.
\item When cloud masking is not supported, \code{MaskedImage.mask_clouds()} leaves the image unaltered instead of applying a fill mask.
\item \code{MaskedImage.scale} is in units of its CRS, not meters.
}
}

\section{New Features}{

\itemize{
\item A new API is provided via \code{gd} accessors on the \code{ee.Image} and \code{ee.ImageCollection} Earth Engine classes.
\item Client-side access to image and collection properties.
\item Images and image collections can be exported to GeoTIFF file, NumPy array, Xarray DataArray / Dataset and Google Cloud platforms.
\item Support for exporting to Cloud Optimised GeoTIFF.
\item A custom \code{nodata} value can be set when exporting to GeoTIFF.
\item Cloud masking support is extended to Landsat C2 collections.
}
}

\section{Backward Compatibility}{


\code{rgeedim} provides a backward compatibility layer to ensure that code written for \code{geedim} 1.x.x continues to work with \code{geedim} 2.x.x. This is achieved by checking the \code{geedim} version at runtime and using the appropriate API.

If you need to use the old behaviors, you can pin the \code{geedim} version to \verb{1.9.0} using \code{reticulate::virtualenv_install()}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{reticulate::virtualenv_install("r-rgeedim", "geedim==1.9.0")
}\if{html}{\out{</div>}}
}

\section{Class Equivalents}{
\tabular{ll}{
   geedim 1.x.x \tab geedim 2.x.x \cr
   \code{MaskedImage} \tab \code{ImageAccessor} \cr
   \code{MaskedCollection} \tab \code{ImageCollectionAccessor} \cr
}
}

