% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ee_check.R
\name{ee_check-tools}
\alias{ee_check-tools}
\alias{ee_check}
\alias{ee_check_python}
\alias{ee_check_python_packages}
\alias{ee_check_credentials}
\alias{ee_check_gcloud}
\title{Interface to check Python and non-R dependencies}
\usage{
ee_check(user = NULL, quiet = FALSE)

ee_check_python(quiet = FALSE)

ee_check_python_packages(quiet = FALSE)

ee_check_credentials(quiet = FALSE)

ee_check_gcloud()
}
\arguments{
\item{user}{Character.User to check credentials. If this parameter is not defined,
then the check for credentials will be skipped.}

\item{quiet}{Logical. Suppress info message}
}
\value{
No return value, called for checking non-R rgee dependencies.
}
\description{
R function for checking Google credentials (Google Earth Engine,
Google Drive and Google Cloud Storage), Python environment and
Third-Party Python Packages used by rgee. Besides, from v0.1.304,
earthengine-api (Python side) requires gcloud to manage
authentication (see \link{ee_Authenticate}).
}
\examples{
\dontrun{
library(rgee)

ee_check_python()
ee_check_python_packages()
ee_check_credentials()
ee_check_gcloud()
ee_check() # put them all together

## Install gcloud in Unix systems
## 1. Download/Install gcloud
# system("curl -sSL https://sdk.cloud.google.com | bash")
## 2. Set the PATH ENV
# sdkpath <- sprintf("\%s/google-cloud-sdk/bin/", Sys.getenv("HOME"))
# Sys.setenv(PATH=sprintf("\%s:\%s", Sys.getenv("PATH"), sdkpath))
}
}
\concept{ee_check functions}
