% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fills.R
\name{fills}
\alias{fills}
\title{Get List of Most Recent Fills}
\usage{
fills(api.key, secret, passphrase, product_id = NULL)
}
\arguments{
\item{api.key}{Mandatory character value. This is the API key as generated by GDAX. Typically a 32 character value.}

\item{secret}{Mandatory character value. This is the API secret as generated by GDAX. Typically a 88 character value.}

\item{passphrase}{Mandatory character value. This is the passphrase as generated by GDAX. Typically a 11 character value.}

\item{product_id}{Optional character value for the currency pair. The default is \code{NULL} which is equivalent of 100 most recent fills. This param when provided is case insensitive and must be one of the valid currency-pair. The list of valid currency-pairs can be fetched using \code{\link{public_info}}.}
}
\value{
Dataframe with fills for all products or for the provided products. The volume is quoted in USD.
}
\description{
This is an auth based function. User must have valid api keys generated by GDAX which must be passed as mandatory arguments. The functions takes product_id as an optional param and returns a list of all previously filled orders.
}
\examples{
\dontrun{
fills(api.key = your_key,
secret = your_api_secret,
passphrase = your_api_pass,
product_id = "BTC-USD")
}

}
