% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_spec.r
\name{print.report_spec}
\alias{print.report_spec}
\title{Prints the report specification}
\usage{
\method{print}{report_spec}(x, ..., verbose = FALSE)
}
\arguments{
\item{x}{The report spec.}

\item{...}{Additional parameters to pass to the underlying print function.}

\item{verbose}{Whether to print the report object in verbose (list) form
or summary form.  The default is FALSE.}
}
\value{
The report spec, invisibly.
}
\description{
A function to print the report specification.
The \strong{print} function will print the report spec in summary 
form by default.  To print in list form, set the \code{verbose} parameter
to TRUE.
}
\examples{
library(reporter)
library(magrittr)

# Create temp file path
tmp <- file.path(tempdir(), "mtcars.txt")

# Create the table
tbl <- create_table(mtcars) \%>\% 
  titles("Table 1.0", "MTCARS Sample Report") \%>\% 
  footnotes("* NOTE: Data from 1974")

# Create the report object
rpt <- create_report(tmp) \%>\% 
  add_content(tbl, align = "left") 

# Write the report to the file system
res <- write_report(rpt)

# Write the modified report object to the console
print(res)

# # A report specification: 1 pages
# - file_path: 'C:/Users/User/AppData/Local/Temp/RtmpWQybXs/mtcars.txt'
# - output_type: TXT
# - units: inches
# - orientation: landscape
# - line size/count: 108/45
# - content: 
# # A table specification:
# - data: data.frame 'mtcars' 32 rows 11 cols
# - show_cols: all
# - use_attributes: all
# - title 1: 'Table 1.0'
# - title 2: 'MTCARS Sample Report'
# - footnote 1: '* NOTE: Data from 1974'
}
\seealso{
\code{\link{create_report}} function to create a report specification.

Other report: 
\code{\link{add_content}()},
\code{\link{create_report}()},
\code{\link{footer_image}()},
\code{\link{footnotes}()},
\code{\link{header_image}()},
\code{\link{options_fixed}()},
\code{\link{page_by}()},
\code{\link{page_footer}()},
\code{\link{page_header}()},
\code{\link{set_margins}()},
\code{\link{title_header}()},
\code{\link{titles}()},
\code{\link{write_report}()}
}
\concept{report}
