% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rs_setup.R
\name{rs_setup}
\alias{rs_setup}
\title{Pass values to setup function and the global environment will be arranged for use  reporting tools.}
\usage{
rs_setup(
  R_DICTION = "./inst/formats",
  R_MACDIRS = NULL,
  R_DDDATA = NULL,
  R_OTHERDATA = paste0("./data"),
  R_INPUTDATA = paste0("./data"),
  R_RAWDATA = paste0("./data"),
  R_SDTMDATA = paste0("./data"),
  R_ADAMDATA = paste0("./data"),
  R_RFMTDIR = paste0("./inst/formats"),
  D_CENTID = "SITEID",
  D_DATADATE = NULL,
  D_DSPLYNUM = 1,
  D_DSPLYTYP = "T",
  D_FONTSIZE = 10,
  D_KEEPPOPVARS = NULL,
  D_OUTFILE = "./inst/t_ru_list_1.rtf",
  D_PGMPTH = "./R/rs_setup.R",
  D_STUDYID = NULL,
  D_STUDY_DESC = NULL,
  D_POP = "ITTEFL",
  D_POPDATA = NULL,
  D_POPLBL = "Intent-to-Treat",
  D_SUBJID = "USUBJID",
  D_SUBPOP = NULL,
  D_SUBSET = NULL,
  D_TITLE1 = NULL,
  D_TITLE2 = NULL,
  D_TITLE3 = NULL,
  D_TITLE4 = NULL,
  D_TITLE5 = NULL,
  D_TITLE6 = NULL,
  D_TITLE7 = NULL,
  D_FOOT1 = NULL,
  D_FOOT2 = NULL,
  D_FOOT3 = NULL,
  D_FOOT4 = NULL,
  D_FOOT5 = NULL,
  D_FOOT6 = NULL,
  D_FOOT7 = NULL,
  D_FOOT8 = NULL,
  D_FOOT9 = NULL,
  D_USERID = Sys.getenv("USERNAME"),
  D_RTFYN = "N",
  D_DEBUG = 0,
  RetEnv = FALSE
)
}
\arguments{
\item{R_DICTION}{Location of reporting dictionaries.}

\item{R_MACDIRS}{List of folders to search for functions when they are invoked.}

\item{R_DDDATA}{Location to write DDDATA reporting data sets.}

\item{R_OTHERDATA}{Location of additional production data sets.}

\item{R_INPUTDATA}{Location of permanent formats data sets and miscellaneous data sets.}

\item{R_RAWDATA}{Location of raw data sets.}

\item{R_SDTMDATA}{Location of SDTM data sets.}

\item{R_ADAMDATA}{Location of ADAM data sets.}

\item{R_RFMTDIR}{Location of format catalogs and corresponding lists.}

\item{D_CENTID}{Variable name for investigational center.}

\item{D_DATADATE}{Date of data sets for use in titles/footnotes.}

\item{D_DSPLYNUM}{Display number for title.}

\item{D_DSPLYTYP}{Type of Display ('T','L','F').}

\item{D_FONTSIZE}{Size of font on output file which is RTF by default (with automated PDF conversion via script).}

\item{D_KEEPPOPVARS}{Variables to keep on the population data set when merging to apply populations and sub-populations.}

\item{D_OUTFILE}{Production location for output TLFs.}

\item{D_PGMPTH}{Path of the driver file that generates current outputs or data sets.}

\item{D_STUDYID}{Protocol ID for the study.}

\item{D_STUDY_DESC}{Description of Study.}

\item{D_POP}{Population variable from ADSL that must equal Y for subjects to be included in the analysis.}

\item{D_POPDATA}{Data set that contains the population to be analyzed.}

\item{D_POPLBL}{Label for population being analyzed which can be used in the TLF header.}

\item{D_SUBJID}{The variable used to uniquely identify a subject in this analysis.}

\item{D_SUBPOP}{Condition to identify the sub-population when applied to ADSL.}

\item{D_SUBSET}{Condition to filter data from incoming source data sets used for this TLF.}

\item{D_TITLE1}{First title text.}

\item{D_TITLE2}{Second title text.}

\item{D_TITLE3}{Third title text.}

\item{D_TITLE4}{Fourth title text.}

\item{D_TITLE5}{Fifth title text.}

\item{D_TITLE6}{Sixth title text.}

\item{D_TITLE7}{Seventh title text.}

\item{D_FOOT1}{First footnote text.}

\item{D_FOOT2}{Second footnote text.}

\item{D_FOOT3}{Third footnote text.}

\item{D_FOOT4}{Fourth footnote text.}

\item{D_FOOT5}{Fifth footnote text.}

\item{D_FOOT6}{Sixth footnote text.}

\item{D_FOOT7}{Seventh footnote text.}

\item{D_FOOT8}{Eighth footnote text.}

\item{D_FOOT9}{Ninth footnote text.}

\item{D_USERID}{User name.}

\item{D_RTFYN}{Y or N to generate RTf output.}

\item{D_DEBUG}{Level of debugging to show in log files.}

\item{RetEnv}{Return environment variable containing current settings.}
}
\value{
'NULL' because variables defined for use with the reporting tools.
}
\description{
Pass values to setup function and the global environment will be arranged for use  reporting tools.
}
\examples{
library(repfun)
library(dplyr)
datdir <- file.path(gsub("\\\\","/",tempdir(),fixed=TRUE),"datdir")
dir.create(datdir,showWarnings=FALSE)
outdir <- file.path(gsub("\\\\","/",tempdir(),fixed=TRUE),"outdir")
dir.create(outdir,showWarnings=FALSE)
fmtdir <- file.path(gsub("\\\\","/",tempdir(),fixed=TRUE),"fmtdir")
dir.create(fmtdir,showWarnings=FALSE)
repfun::copydata(datdir)
repfun::rs_setup(
D_CENTID="SITEID",
D_DATADATE=Sys.Date(),
D_DSPLYNUM=1,
D_DSPLYTYP='T',
D_FONTSIZE=10,
D_FOOT1='1.) Only treatment emergent events related to lipids are displayed.',
D_FOOT2='2.) Subjects are counted once in each body system & preferred term.',
D_KEEPPOPVARS=c('STUDYID','USUBJID','SAFFL'),
D_USERID=Sys.getenv("USERNAME"),
D_STUDYID='ABCXYZPDQ',
D_POP="SAFFL",
D_POPDATA=repfun::adsl \%>\% dplyr::filter(SAFFL=='Y'),
D_POPLBL="Safety",
D_SUBJID=c("STUDYID","USUBJID"),
D_TITLE1=paste0('Table 1: Summary of Treatment Emergent Adverse Events'),
D_RTFYN="Y",
D_DEBUG=0,
R_DICTION=NULL,
R_OTHERDATA=NULL,
R_INPUTDATA=NULL,
R_RAWDATA=NULL,
R_SDTMDATA=NULL,
R_ADAMDATA=datdir,
R_RFMTDIR=fmtdir,
R_DDDATA=paste0(outdir,'/t_ru_list_1.rds'),
D_OUTFILE=paste0(outdir,"/t_ru_list_1.rtf"),
D_PGMPTH="/path/to/code/rs_setup.R")

}
\author{
Yongwei Wang, \email{yongwei.x.wang@viivhealthcare.com} \cr
Chris Rook, \email{cr883296@gmail.com}
}
