% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.R
\name{constraints}
\alias{constraints}
\title{Define constraints for optimization of warping functions}
\usage{
constraints(Kh, t_min = 0, t_max = 1, warping = "nonparametric")
}
\arguments{
\item{Kh}{Number of B-spline basis functions used to estimate warping functions \emph{h}.}

\item{t_min}{Minimum value to be evaluated on the time domain.}

\item{t_max}{Maximum value to be evaluated on the time domain.}

\item{warping}{If \code{nonparametric} (default), inverse warping functions are estimated nonparametrically. 
If \code{piecewise_linear2} they follow a piecewise linear function with 2 knots.}
}
\value{
An list containing:
\item{ui}{A constraint matrix.}
\item{ci}{A constraint vector.}
}
\description{
Constraints ensure monotonicity of spline coefficients for warping functions 
for use with \code{constrOptim()} function.
}
\author{
Julia Wrobel \email{julia.wrobel@cuanschutz.edu},
Erin McDonnell \email{eim2117@cumc.columbia.edu}
}
