% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hsr_cohort_summary.R
\name{hsr_cohort_summary}
\alias{hsr_cohort_summary}
\title{Extract cohort summary information from a Hospital-Specific Report (HSR)}
\usage{
hsr_cohort_summary(file)
}
\arguments{
\item{file}{File path to a report.}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} containing the full Table 2 parsed from the report.
}
\description{
Parses the Table 2 cohort summary from the HSR, including (but not limited to) the discharge/readmission volumes,
predicted/expected readmission rates, peer group medians, and DRG ratios.

\emph{\strong{Note}: CMS changed the format of Hospital-Specific Reports (HSRs) for FY2026 (see \href{https://qualitynet.cms.gov/inpatient/hrrp/reports#tab2}{here}). The current HSR functions support formats through FY2025.}
}
\examples{
# Access a report
my_report <- hsr_mock_reports("FY2025_HRRP_MockHSR.xlsx")

# Extract the cohort summary as a dataset
hsr_cohort_summary(my_report)
}
