% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_sormas-helpers.R
\name{sormas_get_cases_data}
\alias{sormas_get_cases_data}
\title{Get case data from a SORMAS instance}
\usage{
sormas_get_cases_data(login, disease, since)
}
\arguments{
\item{login}{A list with the user's authentication details}

\item{disease}{A character with the target disease name}

\item{since}{A Date value in ISO8601 format (YYYY-mm-dd). Default is \code{0} i.e.
to fetch all cases from the beginning of data collection.}
}
\value{
A data frame with the following eight columns: 'case_id',
'person_id', 'date_onset', 'date_admission', 'case_origin', 'case_status',
'outcome', 'date_outcome'. When not available, the 'person_id' and
'date_outcome' will not be returned.
}
\description{
Get case data from a SORMAS instance
}
\keyword{internal}
