% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flows-maf.r
\name{mafflowmodel}
\alias{mafflowmodel}
\title{Masked Autoregressive Flow (MAF)}
\usage{
mafflowmodel(d = 3, K = 2, theta = NULL)
}
\arguments{
\item{d}{Dimension of the latent space.}

\item{K}{Number of flow steps.}

\item{theta}{Optional parameter vector. If NULL, random initialization.}
}
\value{
A flow model object with methods:
\itemize{
\item sampleq(n)
\item logq(z0)
\item applyflow(z0)
}
}
\description{
A readable and structured implementation of a Masked Autoregressive Flow.
This version supports:
\itemize{
\item arbitrary dimension d
\item K sequential flow steps
\item a single parameter vector theta containing all weights
}
}
