% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arrange.R
\name{arrange.corpus}
\alias{arrange.corpus}
\title{Arrange the document order of a corpus by variables}
\usage{
\method{arrange}{corpus}(.data, ...)
}
\arguments{
\item{.data}{a corpus object whose documents will be sorted}

\item{...}{comma-separated list of unquoted document variables, or
expressions involving document variables. Use \link[dplyr:desc]{desc} to
sort a variable in descending order.}
}
\value{
A corpus with documents reordered according to the specified
variables.
}
\description{
Order the documents in a corpus by variables, including document variables.
}
\examples{
arrange(data_corpus_inaugural[1:5], President)
arrange(data_corpus_inaugural[1:5], c(3, 2, 1, 5, 4))
arrange(data_corpus_inaugural[1:5], desc(President))
}
