#' @name pull
#' @rdname dplyr_cols
#' @importFrom dplyr pull
#' @export
NULL

#' Pull out a single document variable
#'
#' Works like `$` for \pkg{quanteda} objects with document variables, or like
#' `docvars(x, "varname")`.
#' @param .data a \pkg{quanteda} object with document variables
#' @inheritParams dplyr::pull
#' @return A vector containing the values of the specified document variable.
#' @importFrom rlang enquo
#' @importFrom quanteda docvars
#' @export
#' @examples
#' tail(data_corpus_inaugural) %>% pull(President)
#' tail(data_corpus_inaugural) %>% pull(-1)
#' tail(data_corpus_inaugural) %>% pull(1)
#'
pull.corpus <- function(.data, var = -1, name = NULL, ...) {
  var <- enquo(var)
  dv <- docvars(.data)
  if (ncol(dv) == 0) {
    stop("Cannot extract document variables: corpus has no docvars", call. = FALSE)
  }
  pull(dv, !!var)
}

#' @rdname pull.corpus
#' @export
#' @examples
#' toks <- data_corpus_inaugural %>%
#'   tail() %>%
#'   tokens()
#' pull(toks, President)
#'
pull.tokens <- pull.corpus

#' @rdname pull.corpus
#' @export
#' @examples
#' dfmat <- data_corpus_inaugural %>%
#'   tail() %>%
#'   tokens() %>%
#'   dfm()
#' pull(dfmat, President)
#'
pull.dfm <- pull.corpus
