% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qlm_trail.R
\name{qlm_trail}
\alias{qlm_trail}
\title{Create an audit trail from quallmer objects}
\usage{
qlm_trail(..., path = NULL)
}
\arguments{
\item{...}{One or more quallmer objects (\code{qlm_coded}, \code{qlm_comparison}, or
\code{qlm_validation}). When multiple objects are provided, they will be used
to reconstruct the complete workflow chain.}

\item{path}{Optional base path for saving the audit trail. When provided,
creates \verb{\{path\}.rds} (complete archive) and \verb{\{path\}.qmd} (human-readable
report). If \code{NULL} (default), the trail is only returned without saving.}
}
\value{
A \code{qlm_trail} object containing:

\describe{
\item{runs}{List of run information with coded data, ordered from oldest to newest}
\item{complete}{Logical indicating whether all parent references were resolved}
}
}
\description{
Creates a complete audit trail documenting your qualitative coding workflow.
Following Lincoln and Guba's (1985) concept of the audit trail for
establishing trustworthiness in qualitative research, this function captures
the full decision history of your AI-assisted coding process.
}
\details{
Lincoln and Guba (1985, pp. 319-320) describe six categories of audit trail
materials for establishing trustworthiness in qualitative research.
The quallmer package operationalizes these for LLM-assisted text analysis:

\describe{
\item{Raw data}{Original texts stored in coded objects}
\item{Data reduction products}{Coded results from each run}
\item{Data reconstruction products}{Comparisons and validations}
\item{Process notes}{Model parameters, timestamps, decision history}
\item{Materials relating to intentions}{Function calls documenting intent}
\item{Instrument development information}{Codebook with instructions and schema}
}

When \code{path} is provided, the function creates:
\itemize{
\item \verb{\{path\}.rds}: Complete trail object for R (reloadable with \code{readRDS()})
\item \verb{\{path\}.qmd}: Quarto document with full audit trail documentation
}
}
\examples{
# Load example coded objects
examples <- readRDS(system.file("extdata", "example_objects.rds", package = "quallmer"))

# View audit trail from two coding runs
trail <- qlm_trail(
  examples$example_coded_sentiment,
  examples$example_coded_mini
)
print(trail)

\donttest{
# Save complete audit trail (creates .rds and .qmd files)
qlm_trail(
  examples$example_coded_sentiment,
  examples$example_coded_mini,
  path = tempfile("my_analysis")
)
}

}
\references{
Lincoln, Y. S., & Guba, E. G. (1985). \emph{Naturalistic Inquiry}. Sage.
}
\seealso{
\code{\link[=qlm_code]{qlm_code()}}, \code{\link[=qlm_replicate]{qlm_replicate()}}, \code{\link[=qlm_compare]{qlm_compare()}}, \code{\link[=qlm_validate]{qlm_validate()}}
}
