% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qcs.one.r
\name{qcs.one}
\alias{qcs.one}
\alias{qcs.one.default}
\alias{qcs.one.qcd}
\title{Function to plot the Shewhart xbar.one chart}
\usage{
qcs.one(x, ...)

\method{qcs.one}{default}(
  x,
  var.index = 1,
  sample.index = 2,
  covar.index = NULL,
  covar.names = NULL,
  data.name = NULL,
  sizes = NULL,
  center = NULL,
  std.dev = c("MR", "SD"),
  k = 2,
  conf.nsigma = 3,
  limits = NULL,
  plot = FALSE,
  ...
)

\method{qcs.one}{qcd}(
  x,
  center = NULL,
  std.dev = c("MR", "SD"),
  k = 2,
  conf.nsigma = 3,
  limits = NULL,
  plot = FALSE,
  ...
)
}
\arguments{
\item{x}{Object qcd (Quality Control Data)}

\item{...}{arguments passed to or from methods.}

\item{var.index}{a scalar with the column number corresponding to the observed data for
the variable (the variable quality).  Alternativelly can be a string with the
name of the quality variable.}

\item{sample.index}{a scalar with the column number corresponding to the index each
group (sample).}

\item{covar.index}{optional. A scalar or numeric vector with the column number(s)
corresponding to the covariate(s). Alternativelly it can be a character vector with
the names of the covariates.}

\item{covar.names}{optional. A string or vector of strings with names for the
covariate columns.  Only valid if there is more than one column of data. By
default, takes the names from the original object.}

\item{data.name}{a string specifying the name of the variable which appears on the
plots. If not provided it is taken from the object given as data.}

\item{sizes}{optional. A value or a vector of values specifying the sample sizes
associated with each group. For continuous data the sample sizes are obtained counting the non-\code{NA} elements of
the sample.index vector. For attribute
variable the argument sizes is required.}

\item{center}{a value specifying the center of group statistics or the
''target'' value of the process.}

\item{std.dev}{a value or an available method specifying the within-group standard
deviation(s) of the process. Several methods are available for estimating the
standard deviation in case of a continuous process variable.}

\item{k}{number of successive pairs of observations for computing the
standard deviation based on moving ranges of k points.}

\item{conf.nsigma}{a numeric value used to compute control limits, specifying the
number of standard deviations (if \code{conf.nsigma} > 1) or the confidence level (if 0
< \code{conf.nsigma} < 1).}

\item{limits}{a two-value vector specifying control limits.}

\item{plot}{a logical value indicating should be plotted.}
}
\description{
This function is used to compute statistics required by the xbar.one chart.
}
\examples{

##
##  Continuous data 
##
library(qcr)
x <- c(33.75, 33.05, 34, 33.81, 33.46, 34.02, 33.68, 33.27, 33.49, 33.20,
      33.62, 33.00, 33.54, 33.12, 33.84)

sample <- 1:length(x)
datos <- data.frame(x,sample)
datos.qcd <- qcd(datos)

res.qcs <- qcs.one(datos.qcd)
class(res.qcs)
summary(res.qcs)  
 plot(res.qcs, title = "Control Chart Xbar.one for pistonrings")  

}
