% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psrwe_ps_match.R
\name{psrwe_match}
\alias{psrwe_match}
\title{PS matching}
\usage{
psrwe_match(
  dta_ps,
  ratio = 3,
  strata_covs = NULL,
  caliper = 1,
  seed = NULL,
  method = c("nnwor", "optm"),
  .drop_arg_fml = FALSE,
  ...
)
}
\arguments{
\item{dta_ps}{A list of class \code{PSRWE_DAT} that is generated using the
\code{\link{psrwe_est}} function.}

\item{ratio}{Matching ratio (RWD : Current). Default is 3
(i.e., 3:1 matching).}

\item{strata_covs}{Covariates used for stratification in matching.}

\item{caliper}{PS matching caliper width. Default 1. This specifies a
width (Euclidean distance) on the probability scale.}

\item{seed}{Random seed.}

\item{method}{matching algorithm for PS matching.}

\item{.drop_arg_fml}{internal use to drop arguments and call, this is
only used in cjk.}

\item{...}{Additional parameters for matching}
}
\value{
A list of class \code{PSRWE_DTA_MAT} with items:

\describe{

\item{data}{Original data with column \code{_ps_} for estimated PS scores,
  \code{match_id} for matched current study subject ID, and \code{_strata_}
  for PS stratum added.}
\item{ps_fml}{PS formula for estimated PS scores.}
\item{nstrata}{Number of strata.}
\item{ratio}{Matching ratio.}

}
}
\description{
Match patients in the external data source with patients in
    the current study based on PS using the nearest neighbor method.
}
\examples{
data(ex_dta)
dta_ps <- psrwe_est(ex_dta,
                     v_covs = paste("V", 1:7, sep = ""),
                     v_grp = "Group",
                     cur_grp_level = "current")

## With neighest neighbor
.remark_nnmatch <- function() {
  dta_ps_mat <- psrwe_match(dta_ps, ratio = 2, strata_covs = "V1",
                            seed = 123)
  dta_ps_mat
}
## Unmark below to run
# .remark_nnmatch()

## With optmatch
.remark_optmatch <- function() {
    warning("The optmatch package may restrict use (academic license).")
    dta_ps_opt <- psrwe_match(dta_ps, ratio = 2,
                               strata_covs = "V1",
                               method = "optm", seed = 123)
    dta_ps_opt
}
## Unmark below to run if optmatch is available.
# .remark_optmatch()

}
