% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lovb_stats.R
\name{lovb_stats}
\alias{lovb_stats}
\title{Extract Data from League One Volleyball Website}
\usage{
lovb_stats(team = NULL, year = NULL, level = NULL)
}
\arguments{
\item{team}{A character string specifying the team name or city. Accepts
city names (e.g., "Omaha", "Atlanta") or variations like "Indianapolis"
(converted to "Indy") and "Las Vegas" (converted to "Vegas"). Must match
one of the valid LOVB or MLV team cities. AU has no teams.}

\item{year}{A numeric value specifying the year for which to retrieve
statistics. Must be 2024 or later for LOVB or MLV and 2021 or later for AU.}

\item{level}{A character string specifying whether to extract the "team" or individual
"player" statistics. AU has no team statistics.}
}
\value{
A tibble containing team match-by-match or player season statistics.

Team match data include:
year, team, opponent, date, points, hitting_efficiency, kill_percentage, kills, attack_errors, attacks_blocked, attack_attempts, in_system_percentage, reception_errors, reception_attempts, service_aces, service_errors, opponent_in_system_percentage, service_attempts, blocks, block_touch_percentage, digs, dig_percentage, assists, setting_efficiency

Player data include:
year, team, number, player, points, matches_started, sets_started, sets_played, hitting_efficiency, kill_percentage, kills, attack_errors, attacks_blocked, attack_attempts, in_system_percentage, reception_errors, reception_attempts, service_aces, service_errors, opponent_in_system_percentage, service_attempts, blocks, block_touch_percentage, digs, dig_percentage, assists, setting_efficiency
}
\description{
This function scrapes team match-by-match and player season statistics for League One
Volleyball (LOVB) teams from the official LOVB website
\url{https://www.lovb.com}.
}
\note{
This function requires:
\itemize{
\item The \if{html}{\out{<a href="https://ashbythorpe.github.io/selenider/">}}\if{html}{\out{<code>}}\{selenider\}\if{html}{\out{</code>}}\if{html}{\out{</a>}} R package
for web automation
\item \href{https://www.google.com/chrome/}{Google Chrome} browser installed on the system
\item An active internet connection
}

The function uses a headless Chrome browser session, so no browser window
will be visible during execution. Browser sessions are automatically closed
after data extraction.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# Get Omaha Supernovas 2024 match statistics
lovb_stats(team = "Omaha", year = 2025, level = "team")
lovb_stats(team = "Omaha", year = 2025, level = "player")
\dontshow{\}) # examplesIf}
}
\seealso{
Other statistics functions: 
\code{\link{au_stats}()},
\code{\link{get_stats}()},
\code{\link{group_stats}()},
\code{\link{mlv_stats}()}
}
\concept{statistics functions}
