% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{get_neighborhood}
\alias{get_neighborhood}
\title{Obtain dependencies and reverse dependencies of a set of packages}
\usage{
get_neighborhood(
  packages,
  level = 1L,
  relation = c("Depends", "Imports", "LinkingTo", "Suggests", "Enhances"),
  strict = FALSE,
  ignore = c("datasets", "utils", "grDevices", "graphics", "stats", "methods")
)
}
\arguments{
\item{packages}{(\code{chr}) Package names}

\item{level}{(\code{count[1]}) Depth of recursive dependency}

\item{relation}{(\code{chr}) Types of relations. Must be a subset of
c("Depends", "Imports", "LinkingTo", "Suggests", "Enhances")}

\item{strict}{(\code{flag[T]}) Whether to consider all packages
(alternately only 'relation' specific packages) when computing dependencies
for the next level}

\item{ignore}{(\code{chr}) Package names to ignore.}
}
\value{
(\code{dataframe}) three columns: \code{pkg_1}, \code{relation} and \code{pkg_2}
}
\description{
Obtain dependencies and reverse dependencies of packages till a
given depth (\code{level}) for a set of dependency types (\code{relation}).
}
\examples{
\dontrun{
init()
# explore first level dependencies
get_neighborhood("mlr3")

# explore second level dependencies
get_neighborhood("caret", level = 2)

# explore first level dependencies of multiple packages
# and consider second level dependencies
get_neighborhood(c("caret", "mlr"))

# get 'imports' specific neighborhood of 'mlr'
get_neighborhood("mlr", relation = "Imports")
}
}
\seealso{
\link{get_dependencies}
}
