% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{to_spatial}
\alias{to_spatial}
\title{Convert a site-by-variable matrix into a SpatRaster or sf object}
\usage{
to_spatial(m, template)
}
\arguments{
\item{m}{Matrix or vector.}

\item{template}{\code{SpatRaster} layer with number of cells equal to the number of rows in m,
or \code{sf} data frame with same number of rows as m.}
}
\value{
\code{SpatRaster} with a layer for every column in \code{m}, or \code{sf} data frame with
a variable for every column in \code{m}, depending on the data type of \code{template}.
}
\description{
Convert a site-by-variable matrix into a SpatRaster or sf object
}
\examples{
ps <- moss()
to_spatial(ps$comm[, 1:5], ps$spatial)
}
