% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ploteq.R
\name{plot_eq}
\alias{plot_eq}
\title{Plot Photosynthetic Models}
\usage{
plot_eq(eqX,
       eq_name,
       i,
       data,
       title,
       species_subset = NULL,
       A_col)
}
\arguments{
\item{eqX}{A function representing the photosynthetic light response equation
(e.g., \code{eq1}, \code{eq2}).}

\item{eq_name}{A character string representing the name of the equation, to
be included in the plot title.}

\item{i}{An integer specifying the index of the species in the \code{inds}
vector.}

\item{data}{A data frame containing the experimental data with at least two
columns: \code{PARi} for the incident light and \code{A} for the measured
photosynthetic rate.}

\item{title}{An optional character string specifying the title of the plot
(defaults to title in the format \code{i SampleID Equation X}.}

\item{species_subset}{An optional vector of species names from \code{inds}
to be plotted. If \code{NULL}, all species in \code{inds} will be used
(default is \code{NULL}).}

\item{A_col}{Allows data column with assimilation measurements to be specified
and defaults to \code{A}.}
}
\value{
A plot of the measured data points for the selected species (open
points), with curve parameters from the fitted equation (black points),
the NLS curve (red line), and the model fit (dashed blue line). It will
also return the reconstructed model fit as a list.
}
\description{
This function plots the fit of a given photosynthetic light
response equation for all or select species in a data set. This base R
plot includes the SampleID and the equation number in the title.
}
\details{
This function takes the equation of photosynthetic light response
models and fits it to the data for a given species. It then plots the
observed and predicted values, highlighting specific points on the curve
(such as the model curve paramaters \code{I15}, \code{I25}, \code{I85},
and \code{I95}), where the number (X) is the carbon assimilation rate at
X percent of the maximum assimilation in the measured data. The equation
name is included in the plot title, and an optional subset of
species can be selected for plotting. The function also calculates
various fit statistics and adds both the original and reconstructed
predictions as curves to the plot.
}
\examples{
\donttest{
# Example with eq1 and all species
# Please note, it may take more than 10 seconds to plot graphs with all species

data(sunflowers)
my_observed_data <- sunflowers
inds <- unique(my_observed_data$SampleID)

# Example with eq1 and all species

for (i in 1:length(inds)) {
   plot_eq(eq1, "eq1", i, data = my_observed_data)
 }

# Example of using the function for all equations with all species or a subset of species

LRCdata <- sunflowers |> filter(SampleID==SampleID)
highlight <- c("Agrestis_1_29/10/19", "Atrorubens_3_11/11/2019", "Divaricatus_2_29/10/19",
"Gracilentus_2_3/11/2019", "Gracilentus_5_5/11/2019", "Silphiodias_1_3/11/2019")
par(mfrow = c(3, 3))

for (i in 1:length(highlight)) {
  # Add equation names to the function calls
  plot_eq(eq1, "eq1", i, data = LRCdata, species_subset = highlight)
  plot_eq(eq2, "eq2", i, data = LRCdata, species_subset = highlight)
  plot_eq(eq3, "eq3", i, data = LRCdata, species_subset = highlight)
  plot_eq(eq4, "eq4", i, data = LRCdata, species_subset = highlight)
  plot_eq(eq5, "eq5", i, data = LRCdata, species_subset = highlight)
  plot_eq(eq6, "eq6", i, data = LRCdata, species_subset = highlight)
  plot_eq(eq8, "eq8", i, data = LRCdata, species_subset = highlight)
  plot_eq(eq9, "eq9", i, data = LRCdata, species_subset = highlight)
  plot_eq(eq11, "eq11", i, data = LRCdata, species_subset = highlight)
  dev.off()
    }
    oldpar<- par(mfrow = c(1,2))
    par(oldpar)
    on.exit()
}

}
