% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phinterval.R
\name{is_recognized_tzone}
\alias{is_recognized_tzone}
\title{Test if the object is a recognized time zone}
\usage{
is_recognized_tzone(x)
}
\arguments{
\item{x}{An object to test.}
}
\value{
\code{TRUE} if \code{x} is a recognized time zone, \code{FALSE} otherwise.
}
\description{
\code{is_recognized_tzone()} returns \code{TRUE} for strings that are recognized IANA
time zone names, and \code{FALSE} otherwise.
}
\details{
Recognized time zones are those listed in \code{\link[tzdb:tzdb_names]{tzdb::tzdb_names()}}, which
provides an up-to-date copy of time zones from the IANA time zone database.

\verb{<phinterval>} vectors with an unrecognized time zone are formatted using
the \code{"UTC"} time zone with a warning.
}
\examples{
is_recognized_tzone("UTC")
is_recognized_tzone("America/New_York")
is_recognized_tzone("")
is_recognized_tzone("badzone")
is_recognized_tzone(10L)

}
