% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doubleLogis.R
\name{doubleLogis}
\alias{doubleLogis}
\title{Double logistic function for the time-series data.}
\usage{
doubleLogis(
  dat,
  x,
  y,
  returnModels = FALSE,
  start = c(r2 = 0.05, r3 = 0.05, d2 = 40, d3 = 100),
  upper = c(r2 = 1, r3 = 1, d2 = 200, d3 = 200),
  lower = c(r2 = 0, r3 = 0, d2 = 0, d3 = 0)
)
}
\arguments{
\item{dat}{data.frame including date and trait (e.g. canopy height).}

\item{x}{Column name (character) for the date after sowing or planting.}

\item{y}{Column name (character) for the trait.}

\item{returnModels}{Logical value whether to return the time-series model object. Default is F.}

\item{start}{Start values to estimate 'r2', 'r3', 'd2' and 'd3'. Default is 'c(r2 = 0.05, r3 = 0.05, d2 = 40, d3 = 100)'.}

\item{upper}{Upper bounds to estimate 'r2', 'r3', 'd2' and 'd3'. Default is 'c(r2 = 1, r3 = 1, d2 = 200, d3 = 200)'.}

\item{lower}{Lower bounds to estimate 'r2', 'r3', 'd2' and 'd3'. Default is 'c(r2 = 0, r3 = 0, d2 = 0, d3 = 0)'.}
}
\value{
doubleLogis function returns the vector of estimated parameter values.
If returnModels = TRUE, this function also returns the nls regression object.
}
\description{
Apply a time-series model, double logistic function
, to the time-series trait data.
This function was originally developed for the time-series data of rice CIg data.
Fitting the time-series model is done by the "two-step procedure".
For more information, see Taniguchi et al. (under review).
}
\examples{
library(phenolocrop)
riceCIg_eg |>
   doubleLogis("x", "CIg")

}
\references{
S. Taniguchi et al. (2025) Phenology analysis for trait prediction using UAVs
in a MAGIC rice population with different transplanting protocols.
 Frontiers in Artificial Intelligence, 7, 1477637.
}
