# This file is automatically generated by data-raw/create_adams_data.R.
# For updating it please edit inst/extdata/adams-specs.xlsx and rerun create_adams_data.R.
# Manual edits are not recommended, as changes may be overwritten.
#'
#' @name advs_metabolic
#' @title Vital Signs Analysis for Metabolic
#' @keywords dataset metabolic
#' @docType data
#' @format A data frame with 101 columns:
#'   \describe{
#'     \item{ STUDYID }{Study Identifier}
#'     \item{ USUBJID }{Unique Subject Identifier}
#'     \item{ SUBJID }{Subject Identifier for the Study}
#'     \item{ SITEID }{Study Site Identifier}
#'     \item{ COUNTRY }{Country}
#'     \item{ DOMAIN }{Domain Abbreviation}
#'     \item{ RFSTDTC }{Subject Reference Start Date/Time}
#'     \item{ RFENDTC }{Subject Reference End Date/Time}
#'     \item{ RFXSTDTC }{Date/Time of First Study Treatment}
#'     \item{ RFXENDTC }{Date/Time of Last Study Treatment}
#'     \item{ RFPENDTC }{Date/Time of End of Participation}
#'     \item{ SCRFDT }{Screen Failure Date}
#'     \item{ FRVDT }{Final Retrieval Visit Date}
#'     \item{ DTHDTC }{Date/Time of Death}
#'     \item{ DTHADY }{Relative Day of Death}
#'     \item{ DTHFL }{Subject Death Flag}
#'     \item{ LDDTHELD }{Elapsed Days from Last Dose to Death}
#'     \item{ LDDTHGR1 }{Last Dose to Death - Days Elapsed Grp 1}
#'     \item{ DTH30FL }{Death Within 30 Days of Last Trt Flag}
#'     \item{ DTHA30FL }{Death After 30 Days from Last Trt Flag}
#'     \item{ DTHDOM }{Domain for Date of Death Collection}
#'     \item{ DTHB30FL }{Death Within 30 Days of First Trt Flag}
#'     \item{ ASEQ }{Analysis Sequence Number}
#'     \item{ REGION1 }{Geographic Region 1}
#'     \item{ DMDTC }{Date/Time of Collection}
#'     \item{ DMDY }{Study Day of Collection}
#'     \item{ AGE }{Age}
#'     \item{ AGEU }{Age Units}
#'     \item{ AGEGR1 }{Pooled Age Group 1}
#'     \item{ SEX }{Sex}
#'     \item{ RACE }{Race}
#'     \item{ RACEGR1 }{Pooled Race Group 1}
#'     \item{ ETHNIC }{Ethnicity}
#'     \item{ SAFFL }{Safety Population Flag}
#'     \item{ ARM }{Description of Planned Arm}
#'     \item{ ARMCD }{Planned Arm Code}
#'     \item{ ACTARM }{Description of Actual Arm}
#'     \item{ ACTARMCD }{Actual Arm Code}
#'     \item{ TRT01P }{Planned Treatment for Period 01}
#'     \item{ TRT01A }{Actual Treatment for Period 01}
#'     \item{ TRTSDT }{Date of First Exposure to Treatment}
#'     \item{ TRTSDTM }{Datetime of First Exposure to Treatment}
#'     \item{ TRTSTMF }{Time of First Exposure Imput. Flag}
#'     \item{ TRTEDT }{Date of Last Exposure to Treatment}
#'     \item{ TRTEDTM }{Datetime of Last Exposure to Treatment}
#'     \item{ TRTETMF }{Time of Last Exposure Imput. Flag}
#'     \item{ EOSSTT }{End of Study Status}
#'     \item{ EOSDT }{End of Study Date}
#'     \item{ RFICDTC }{Date/Time of Informed Consent}
#'     \item{ RANDDT }{Date of Randomization}
#'     \item{ LSTALVDT }{Date Last Known Alive}
#'     \item{ TRTDURD }{Total Treatment Duration (Days)}
#'     \item{ DTHDT }{Date of Death}
#'     \item{ DTHDTF }{Date of Death Imputation Flag}
#'     \item{ DTHCAUS }{Cause of Death}
#'     \item{ DTHCGR1 }{Cause of Death Reason 1}
#'     \item{ ADT }{Analysis Date}
#'     \item{ ADY }{Analysis Relative Day}
#'     \item{ AVISIT }{Analysis Visit}
#'     \item{ AVISITN }{Analysis Visit (N)}
#'     \item{ ATPT }{Analysis Timepoint}
#'     \item{ ATPTN }{Analysis Timepoint (N)}
#'     \item{ PARAM }{Parameter}
#'     \item{ PARAMCD }{Parameter Code}
#'     \item{ PARAMN }{Parameter (N)}
#'     \item{ PARCAT1 }{Parameter Category 1}
#'     \item{ PARCAT1N }{Parameter Category 1 (N)}
#'     \item{ AVAL }{Analysis Value}
#'     \item{ AVALCAT1 }{Analysis Value Category 1}
#'     \item{ AVALCA1N }{Analysis Value Category 1 (N)}
#'     \item{ BASE }{Baseline Value}
#'     \item{ BASECAT1 }{Baseline Category 1}
#'     \item{ BASECA1N }{Baseline Category 1 (N)}
#'     \item{ CHG }{Change from Baseline}
#'     \item{ PCHG }{Percent Change from Baseline}
#'     \item{ CRIT1 }{Analysis Criterion 1}
#'     \item{ CRIT1FL }{Criterion 1 Evaluation Result Flag}
#'     \item{ CRIT2 }{Analysis Criterion 2}
#'     \item{ CRIT2FL }{Criterion 2 Evaluation Result Flag}
#'     \item{ ABLFL }{Baseline Record Flag}
#'     \item{ VSSEQ }{Sequence Number}
#'     \item{ VSTESTCD }{Vital Signs Test Short Name}
#'     \item{ VSTEST }{Vital Signs Test Name}
#'     \item{ VSPOS }{Vital Signs Position of Subject}
#'     \item{ VSORRES }{Result or Finding in Original Units}
#'     \item{ VSORRESU }{Original Units}
#'     \item{ VSSTRESC }{Character Result/Finding in Std Format}
#'     \item{ VSSTRESN }{Numeric Result/Finding in Standard Units}
#'     \item{ VSSTRESU }{Standard Units}
#'     \item{ VSSTAT }{Completion Status}
#'     \item{ VSLOC }{Location of Vital Signs Measurement}
#'     \item{ VSBLFL }{Baseline Flag}
#'     \item{ VISITNUM }{Visit Number}
#'     \item{ VISIT }{Visit Name}
#'     \item{ VISITDY }{Planned Study Day of Visit}
#'     \item{ VSDTC }{Date/Time of Measurements}
#'     \item{ VSDY }{Study Day of Vital Signs}
#'     \item{ VSTPT }{Planned Time Point Name}
#'     \item{ VSTPTNUM }{Planned Time Point Number}
#'     \item{ VSELTM }{Planned Elapsed Time from Time Point Ref}
#'     \item{ VSTPTREF }{Time Point Reference}
#'   }
#' @details Contains a set of 10 unique Parameter Codes and Parameters: \tabular{ll}{
#'   \strong{PARAMCD} \tab \strong{PARAM} \cr
#'   BMI      \tab Body Mass Index (kg/m2)        \cr
#'   DIABP    \tab Diastolic Blood Pressure (mmHg)\cr
#'   HEIGHT   \tab Height (cm)                    \cr
#'   HIPCIR   \tab Hip Circumference (cm)         \cr
#'   PULSE    \tab Pulse Rate (beats/min)         \cr
#'   SYSBP    \tab Systolic Blood Pressure (mmHg) \cr
#'   TEMP     \tab Temperature (C)                \cr
#'   WAISTHIP \tab Waist to Hip Ratio             \cr
#'   WEIGHT   \tab Weight (kg)                    \cr
#'   WSTCIR   \tab Waist Circumference (cm)
#' }

#'
#' @source Generated from admiralmetabolic package (template ad_advs.R).
#' @references None
#'
#' @examples
#' data("advs_metabolic")
"advs_metabolic"
