% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_delete_object_tagging}
\alias{s3_delete_object_tagging}
\title{This operation is not supported for directory buckets}
\usage{
s3_delete_object_tagging(
  Bucket,
  Key,
  VersionId = NULL,
  ExpectedBucketOwner = NULL
)
}
\arguments{
\item{Bucket}{[required] The bucket name containing the objects from which to remove the tags.

\strong{Access points} - When you use this action with an access point, you
must provide the alias of the access point in place of the bucket name
or specify the access point ARN. When using the access point ARN, you
must direct requests to the access point hostname. The access point
hostname takes the form
\emph{AccessPointName}-\emph{AccountId}.s3-accesspoint.\emph{Region}.amazonaws.com.
When using this action with an access point through the Amazon Web
Services SDKs, you provide the access point ARN in place of the bucket
name. For more information about access point ARNs, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html}{Using access points}
in the \emph{Amazon S3 User Guide}.

\strong{S3 on Outposts} - When you use this action with S3 on Outposts, you
must direct requests to the S3 on Outposts hostname. The S3 on Outposts
hostname takes the form
\code{ AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com}.
When you use this action with S3 on Outposts, the destination bucket
must be the Outposts access point ARN or the access point alias. For
more information about S3 on Outposts, see \href{https://docs.aws.amazon.com/AmazonS3/latest/s3-outposts/S3onOutposts.html}{What is S3 on Outposts?}
in the \emph{Amazon S3 User Guide}.}

\item{Key}{[required] The key that identifies the object in the bucket from which to remove
all tags.}

\item{VersionId}{The versionId of the object that the tag-set will be removed from.}

\item{ExpectedBucketOwner}{The account ID of the expected bucket owner. If the account ID that you
provide does not match the actual owner of the bucket, the request fails
with the HTTP status code \verb{403 Forbidden} (access denied).}
}
\description{
This operation is not supported for directory buckets.

See \url{https://www.paws-r-sdk.com/docs/s3_delete_object_tagging/} for full documentation.
}
\keyword{internal}
