% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup_operations.R
\name{backup_update_region_settings}
\alias{backup_update_region_settings}
\title{Updates the current service opt-in settings for the Region}
\usage{
backup_update_region_settings(
  ResourceTypeOptInPreference = NULL,
  ResourceTypeManagementPreference = NULL
)
}
\arguments{
\item{ResourceTypeOptInPreference}{Updates the list of services along with the opt-in preferences for the
Region.

If resource assignments are only based on tags, then service opt-in
settings are applied. If a resource type is explicitly assigned to a
backup plan, such as Amazon S3, Amazon EC2, or Amazon RDS, it will be
included in the backup even if the opt-in is not enabled for that
particular service. If both a resource type and tags are specified in a
resource assignment, the resource type specified in the backup plan
takes priority over the tag condition. Service opt-in settings are
disregarded in this situation.}

\item{ResourceTypeManagementPreference}{Enables or disables full Backup management of backups for a resource
type. To enable full Backup management for DynamoDB along with \href{https://docs.aws.amazon.com/aws-backup/latest/devguide/advanced-ddb-backup.html}{Backup's advanced DynamoDB backup features},
follow the procedure to \href{https://docs.aws.amazon.com/aws-backup/latest/devguide/advanced-ddb-backup.html#advanced-ddb-backup-enable-cli}{enable advanced DynamoDB backup programmatically}.}
}
\description{
Updates the current service opt-in settings for the Region.

See \url{https://www.paws-r-sdk.com/docs/backup_update_region_settings/} for full documentation.
}
\keyword{internal}
