% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partykit.R
\name{ctree_train}
\alias{ctree_train}
\alias{cforest_train}
\title{A wrapper function for conditional inference tree models}
\usage{
ctree_train(
  formula,
  data,
  weights = NULL,
  minsplit = 20L,
  maxdepth = Inf,
  teststat = "quadratic",
  testtype = "Bonferroni",
  mincriterion = 0.95,
  ...
)

cforest_train(
  formula,
  data,
  weights = NULL,
  minsplit = 20L,
  maxdepth = Inf,
  teststat = "quadratic",
  testtype = "Univariate",
  mincriterion = 0,
  mtry = ceiling(sqrt(ncol(data) - 1)),
  ntree = 500L,
  ...
)
}
\arguments{
\item{formula}{A symbolic description of the model to be fit.}

\item{data}{A data frame containing the variables in the model.}

\item{weights}{A vector of weights whose length is the same as \code{nrow(data)}.
For \code{\link[partykit:ctree]{partykit::ctree()}} models, these are required to be non-negative
integers while for \code{\link[partykit:cforest]{partykit::cforest()}} they can be non-negative integers
or doubles.}

\item{minsplit}{The minimum sum of weights in a node in order to be
considered for splitting.}

\item{maxdepth}{maximum depth of the tree. The default \code{maxdepth = Inf}
means that no restrictions are applied to tree sizes.}

\item{teststat}{A character specifying the type of the test statistic to be
applied.}

\item{testtype}{A character specifying how to compute the distribution of
the test statistic.}

\item{mincriterion}{The value of the test statistic (for \code{testtype ==
"Teststatistic"}), or 1 - p-value (for other values of \code{testtype}) that
must be exceeded in order to implement a split.}

\item{...}{Other options to pass to \code{\link[partykit:ctree]{partykit::ctree()}} or \code{\link[partykit:cforest]{partykit::cforest()}}.}

\item{mtry}{Number of input variables randomly sampled as candidates at each
node for random forest like algorithms. The default \code{mtry = Inf} means
that no random selection takes place.}

\item{ntree}{Number of trees to grow in a forest.}
}
\value{
An object of class \code{party} (for \code{ctree}) or \code{cforest}.
}
\description{
These functions are slightly different APIs for \code{\link[partykit:ctree]{partykit::ctree()}} and
\code{\link[partykit:cforest]{partykit::cforest()}} that have several important arguments as top-level
arguments (as opposed to being specified in \code{\link[partykit:ctree_control]{partykit::ctree_control()}}).
}
\examples{
\dontshow{if (!parsnip:::is_cran_check()) withAutoprint(\{ # examplesIf}
if (rlang::is_installed(c("modeldata", "partykit"))) {
  data(bivariate, package = "modeldata")
  ctree_train(Class ~ ., data = bivariate_train)
  ctree_train(Class ~ ., data = bivariate_train, maxdepth = 1)
}
\dontshow{\}) # examplesIf}
}
