% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\name{configure_bar}
\alias{configure_bar}
\title{Configure The Progress Bar}
\usage{
configure_bar(type = "modern", ...)
}
\arguments{
\item{type}{A character string specifying the type of progress bar to be used
with compatible \code{\link[=Backend]{backends}}. Possible values are
\code{"modern"} and \code{"basic"}. The default value is \code{"modern"}.}

\item{...}{A list of named arguments used to configure the progress bar. See
the \strong{Details} section for more information.}
}
\value{
The function returns void. It throws an error if the requested bar \code{type} is
not supported.
}
\description{
This function can be used to conveniently configure the progress bar by
adjusting the \code{progress_bar_config} field of the
\code{\link[=Options]{Options}} instance in the \code{\link[base:options]{base::.Options}} list.
}
\details{
The optional \code{...} named arguments depend on the \code{type} of progress bar being
configured. When \code{type = "modern"}, the \code{...} take the named arguments of the
\code{\link[progress:progress_bar]{progress::progress_bar}} class. When \code{type = "basic"}, the \code{...} take the
named arguments of the \code{\link[utils:txtProgressBar]{utils::txtProgressBar()}} built-in function. See the
\strong{Examples} section for a demonstration.
}
\examples{
# Set the default package options.
set_default_options()

# Get the progress bar type from options.
get_option("progress_bar_type")

# Get the progress bar configuration from options.
get_option("progress_bar_config")

# Adjust the format of the `modern` progress bar.
configure_bar(type = "modern", format = "[:bar] :percent")

# Check that the configuration has been updated in the options.
get_option("progress_bar_config")

# Change to and adjust the style of the `basic` progress bar.
configure_bar(type = "basic", style = 3)

# Check that the configuration has been updated in the options.
get_option("progress_bar_type")
get_option("progress_bar_config")

}
\seealso{
\code{\link[progress:progress_bar]{progress::progress_bar}}, \code{\link[utils:txtProgressBar]{utils::txtProgressBar()}},
\code{\link[=set_default_options]{set_default_options()}}, \code{\link[=get_option]{get_option()}},
\code{\link[=set_option]{set_option()}}
}
