% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{getBenchmarkInformation}
\alias{getBenchmarkInformation}
\title{Compute cluster information}
\usage{
getBenchmarkInformation(dmat, groups)
}
\arguments{
\item{dmat}{distance matrix}

\item{groups}{groups resulting from clustering}
}
\value{
data frame with cluster information
}
\description{
The returned tibble contains the id of the cluster benchmark,
the cluster radius and diameter, and group number for each cluster.
}
\examples{
dists <- getDists(Bikes$space1,"euclidean")
fit <- stats::hclust(dists, "ward.D2")
groups <- stats::cutree(fit, k = 4)
getBenchmarkInformation(as.matrix(dists), groups)

}
