% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minBranchLength.R
\name{minBranchLength}
\alias{minBranchLength}
\alias{minBranchLen}
\alias{minimumBranchLen}
\alias{minimumBranchLength}
\title{Scales Edge Lengths of a Phylogeny to a Minimum Branch Length}
\usage{
minBranchLength(tree, mbl, modifyRootAge = TRUE)
}
\arguments{
\item{tree}{A phylogeny with edge lengths of class \code{phylo}.}

\item{mbl}{The minimum branch length}

\item{modifyRootAge}{If \code{TRUE} (the default), the input tree is checked for
a root age given as \code{$root.time} and if present it is checked
and fixed for any possible movement backwards due to short
branches close to the root node.}
}
\value{
A phylogeny with edge lengths of class \code{phylo}.
}
\description{
Rescales a tree with edge lengths so that all edge lengths
are at least some minimum branch length 
(sometimes abbreviated as "\code{MBL}" or "\code{mbl}").
Edge lengths are transformed so they are
greater than or equal to the input minimum branch length, by
subtracting edge length from more root-ward edges
and added to later branches. 
This may or may not change the age of the root divergence, depending on the
distribution of short branch lengths close to the root.
}
\details{
This function was formally an internal segment in
\code{\link{timePaleoPhy}}, and now is called by \code{timePaleoPhy}
instead, allowing users to apply \code{minBranchLength}
to trees that already have edge lengths.
}
\examples{

#simulation with an example non-ultrametric tree

tree <- rtree(20)
# randomly replace edges with ZLBs
   # similar to multi2di output
tree <- degradeTree(tree,0.3,
   leave.zlb = TRUE) 	

tree2 <- minBranchLength(tree,0.1)

layout(1:2)

plot(tree)
axisPhylo()
plot(tree2)
axisPhylo()

layout(1)


#now let's try it with an ultrametric case

# get a random tree
tree <- rtree(30)
# randomly replace edges with ZLBs
   # similar to multi2di output
tree <- degradeTree(tree,0.5,leave.zlb = TRUE) 
# now randomly resolve	
tree <- di2multi(tree)
# give branch lengths so its ultrametric
tree <- compute.brlen(tree)

# and we have an ultrametric tree with polytomies, yay!
plot(tree) 

# now randomly resolve
tree2 <- multi2di(tree)
# get new branch lengths as would with real data
tree2 <- minBranchLength(tree2,0.1)

layout(1:2)
plot(tree,show.tip.label = FALSE)
axisPhylo()
plot(tree2,show.tip.label = FALSE)
axisPhylo()

layout(1)

# check that root ages aren't being left unmodified
   # create a tree with lots of ZBLs at the root
x <- stree(10)
x$edge.length <- runif(Nedge(x))
x <- multi2di(x)
# give it a root age
x$root.time <- max(node.depth.edgelength(x))

z <- minBranchLength(tree = x, mbl = 1)
plot(z)

}
\seealso{
This function was originally an internal
piece of \code{\link{timePaleoPhy}},
which implements the minimum branch
length time-scaling method along with others,
which may be what you're looking for
(instead of this miscellaneous function).
}
\author{
David W. Bapst
}
