% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openai_batch_api.R
\name{openai_upload_batch_file}
\alias{openai_upload_batch_file}
\title{Upload a JSONL batch file to OpenAI}
\usage{
openai_upload_batch_file(path, purpose = "batch", api_key = NULL)
}
\arguments{
\item{path}{Path to the local \code{.jsonl} file to upload.}

\item{purpose}{File purpose. For the Batch API this should be \code{"batch"}.}

\item{api_key}{Optional OpenAI API key. Defaults to
\code{Sys.getenv("OPENAI_API_KEY")}.}
}
\value{
A list representing the File object returned by the API, including
\code{id}, \code{filename}, \code{bytes}, \code{purpose}, etc.
}
\description{
Uploads a \code{.jsonl} file to the OpenAI Files API with purpose \code{"batch"},
which can then be used to create a Batch job.
}
\examples{
\dontrun{
# Requires OPENAI_API_KEY set in your environment and network access

file_obj <- openai_upload_batch_file("batch_input.jsonl")
file_obj$id
}

}
