% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{orcid_doi}
\alias{orcid_doi}
\title{Search ORCID by DOI}
\usage{
orcid_doi(dois, fuzzy = FALSE, rows = 10, token = NULL)
}
\arguments{
\item{dois}{Character vector. One or more DOIs to search for.}

\item{fuzzy}{Logical. Use fuzzy matching for DOI search (default: FALSE).
Fuzzy matching allows partial DOI matches.}

\item{rows}{Integer. Number of results per DOI (default: 10).}

\item{token}{Character string or NULL. Optional API token.}
}
\value{
A named list where each element corresponds to a DOI and contains
a data.table of search results. If only one DOI is provided, returns
the data.table directly. Empty data.tables are returned for DOIs with
no matches.
}
\description{
Search for ORCID profiles associated with specific DOIs. This is a
convenience wrapper around \code{\link{orcid}} for DOI-based searches.
}
\details{
This function searches the \code{digital-object-ids} field in the ORCID
registry. When \code{fuzzy = TRUE}, wildcard matching is used to find
partial DOI matches.
}
\examples{
\dontrun{
# Search by single DOI
results <- orcid_doi("10.1371/journal.pone.0025995")
print(results)

# Search by multiple DOIs
dois <- c("10.1038/nature12373", "10.1126/science.1260419")
results <- orcid_doi(dois)
names(results)

# Fuzzy search (partial DOI)
results <- orcid_doi("10.1371/*", fuzzy = TRUE, rows = 20)
}

}
\seealso{
\code{\link{orcid}}, \code{\link{orcid_search}}
}
