% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_add_cell_style}
\alias{wb_add_cell_style}
\title{Modify the style in a cell region}
\usage{
wb_add_cell_style(
  wb,
  sheet = current_sheet(),
  dims = "A1",
  apply_alignment = NULL,
  apply_border = NULL,
  apply_fill = NULL,
  apply_font = NULL,
  apply_number_format = NULL,
  apply_protection = NULL,
  border_id = NULL,
  ext_lst = NULL,
  fill_id = NULL,
  font_id = NULL,
  hidden = NULL,
  horizontal = NULL,
  indent = NULL,
  justify_last_line = NULL,
  locked = NULL,
  num_fmt_id = NULL,
  pivot_button = NULL,
  quote_prefix = NULL,
  reading_order = NULL,
  relative_indent = NULL,
  shrink_to_fit = NULL,
  text_rotation = NULL,
  vertical = NULL,
  wrap_text = NULL,
  xf_id = NULL,
  ...
)
}
\arguments{
\item{wb}{A \link{wbWorkbook} object.}

\item{sheet}{The name or index of the worksheet. Defaults to the current sheet.}

\item{dims}{A character string defining the cell range (e.g., "A1:K1").}

\item{apply_alignment, apply_font, apply_fill, apply_border, apply_number_format, apply_protection}{Logical; explicitly flags whether the spreadsheet software should
apply the corresponding style category.}

\item{ext_lst}{Character; an optional XML string containing an extension list (\verb{<extLst>})
for the cell style.}

\item{font_id, fill_id, border_id, num_fmt_id}{Optional; direct integer IDs
referencing existing style sub-nodes.}

\item{hidden}{Logical; if \code{TRUE}, formulas are hidden when the sheet
is protected.}

\item{horizontal}{Horizontal alignment. One of "general", "left", "center",
"right", "fill", "justify", "centerContinuous", or "distributed".}

\item{indent}{Numeric; the indentation level for the cell content.}

\item{justify_last_line}{Logical; if \code{TRUE}, justifies the last line of text
within the cell (useful for distributed alignment).}

\item{locked}{Logical; if \code{TRUE}, the cell cannot be edited when the
sheet is protected.}

\item{pivot_button}{Logical; indicates if a pivot button should be displayed for the cell.}

\item{quote_prefix}{Logical; if \code{TRUE}, a single quote prefix is displayed in the
formula bar but not the cell itself (often used for numbers stored as text).}

\item{reading_order}{Integer; the reading order for the cell content (e.g.,
1 for Left-to-Right, 2 for Right-to-Left).}

\item{relative_indent}{Integer; the relative indentation level.}

\item{shrink_to_fit}{Logical; automatically reduces font size to fit the
column width.}

\item{text_rotation}{Degrees of rotation (0 to 180).}

\item{vertical}{Vertical alignment. One of "top", "center", "bottom",
"justify", or "distributed".}

\item{wrap_text}{Logical; enables line wrapping within the cell.}

\item{xf_id}{Integer; a direct reference to a master style (XF) ID in the style catalog.}

\item{...}{Additional arguments.}
}
\value{
The \link{wbWorkbook} object, invisibly.

The \code{wbWorkbook} object, invisibly
}
\description{
The \code{wb_add_cell_style()} function provides direct access to the cell-level
formatting record (the \code{xf} node) within a \code{wbWorkbook}. It is primarily
used to control text alignment (horizontal and vertical), text rotation,
indentation, and cell protection (locking and hiding).
}
\details{
While functions like \code{\link[=wb_add_font]{wb_add_font()}} or \code{\link[=wb_add_fill]{wb_add_fill()}} target specific
sub-nodes of a style, \code{wb_add_cell_style()} manages the properties that
govern how content is positioned within the cell boundaries and how it
behaves when a worksheet is protected.

This function also allows for the direct assignment of style element IDs
(e.g., \code{font_id}, \code{fill_id}). This is an advanced feature that allows
users to map pre-existing styles in the workbook's style catalog to specific
cells.

Alignment and Text Control:
Options such as \code{wrap_text}, \code{shrink_to_fit}, and \code{text_rotation} are
essential for managing high-density data or creating stylized headers.
The \code{text_rotation} parameter accepts values in degrees (0–180), where
values above 90 represent downward-slanting text.

Protection:
The \code{locked} and \code{hidden} parameters only take effect when worksheet
protection is enabled (see \code{\link[=wb_protect_worksheet]{wb_protect_worksheet()}}). By default, all
cells in a spreadsheet are "locked," but this has no impact until the
sheet is protected.
}
\examples{
wb <- wb_workbook()
wb <- wb_add_worksheet(wb, "S1")
wb <- wb_add_data(wb, "S1", x = mtcars)

wb <- wb_add_cell_style(
    wb,
    dims = "A1:K1",
    text_rotation = "45",
    horizontal = "center",
    vertical = "center",
    wrap_text = "1"
)
# Chaining
wb <- wb_workbook()$add_worksheet("S1")$add_data(x = mtcars)
wb$add_cell_style(dims = "A1:K1",
                  text_rotation = "45",
                  horizontal = "center",
                  vertical = "center",
                  wrap_text = "1")
}
\seealso{
Other styles: 
\code{\link{wb_add_border}()},
\code{\link{wb_add_fill}()},
\code{\link{wb_add_font}()},
\code{\link{wb_add_named_style}()},
\code{\link{wb_add_numfmt}()},
\code{\link{wb_cell_style}}
}
\concept{styles}
