% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mockConditionOccurrence.R
\name{mockConditionOccurrence}
\alias{mockConditionOccurrence}
\title{Generates a mock condition occurrence table and integrates it into an existing CDM object.}
\usage{
mockConditionOccurrence(cdm, recordPerson = 1, seed = NULL)
}
\arguments{
\item{cdm}{A \code{cdm_reference} object that should already include 'person',
'observation_period', and 'concept' tables.This object is the base
CDM structure where the condition occurrence data will be added.
It is essential that these tables are not empty as they provide
the necessary context for generating condition data.}

\item{recordPerson}{An integer specifying the expected number of condition
records to generate per person.This parameter allows
the simulation of varying frequencies of condition
occurrences among individuals in the cohort,
reflecting the variability seen in real-world medical
data.}

\item{seed}{An optional integer used to set the seed for random number
generation, ensuring reproducibility of the generated data.If
provided, it allows the function to produce the same results
each time it is run with the same inputs.If 'NULL', the seed is
not set, resulting in different outputs on each run.}
}
\value{
Returns the modified \code{cdm} object with the new
'condition_occurrence' table added. This table includes the
simulated condition data for each person, ensuring that each
record is within the valid observation periods and linked to the
correct individuals in the 'person' table.
}
\description{
This function simulates condition occurrences for individuals within a
specified cohort. It helps create a realistic dataset by generating
condition records for each person, based on the number of records specified
per person.The generated data are aligned with the existing observation
periods to ensure that all conditions are recorded within valid observation
windows.
}
\examples{
\donttest{
library(omock)
library(dplyr)
# Create a mock CDM reference and add condition occurrences
cdm <- mockCdmReference() |>
  mockPerson() |>
  mockObservationPeriod() |>
  mockConditionOccurrence(recordPerson = 2)

# View the generated condition occurrence data
cdm$condition_occurrence |>
glimpse()
}
}
