% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nparACT_base.R
\name{nparACT_base}
\alias{nparACT_base}
\title{Compute classic non-parametric actigraphy measures}
\usage{
nparACT_base(name, SR, cutoff = 1, plot = T, fulldays = T)
}
\arguments{
\item{name}{Character string giving the name of the object in the
workspace that contains the actigraphy data.}

\item{SR}{Numeric. Sampling rate in Hertz (samples per second).}

\item{cutoff}{Numeric. Activity threshold used to classify movement.
Defaults to 1.}

\item{plot}{Logical. If \code{TRUE}, diagnostic plots of the hourly
and minute-wise activity profiles are generated. Defaults to \code{TRUE}.}

\item{fulldays}{Logical. If \code{TRUE}, data are truncated to include
only complete 24-hour periods. Defaults to \code{TRUE}.}
}
\value{
A data frame with one row and the following columns:
\describe{
\item{IS}{Interdaily stability}
\item{IV}{Intradaily variability}
\item{RA}{Relative amplitude}
\item{L5}{Mean activity during the least active 5-hour period}
\item{L5_starttime}{Start time of the L5 period}
\item{M10}{Mean activity during the most active 10-hour period}
\item{M10_starttime}{Start time of the M10 period}
}
}
\description{
Computes the classic non-parametric actigraphy measures
interdaily stability (IS), intradaily variability (IV),
relative amplitude (RA), as well as the L5 and M10 values
and their respective start times, for a single actigraphy file.
}
\details{
The function expects the actigraphy data to be available in the
workspace under the name provided via \code{name}. Data are internally
pre-processed, optionally restricted to complete 24-hour periods,
and analysed using standard non-parametric actigraphy algorithms.

The input data may contain either two columns (time, activity) or
three columns (date, time, activity). Time variables are internally
converted to \code{POSIXct}. Missing values in the activity signal
are not permitted.

The computation of IS and IV is based on hourly averaged activity data.
Relative amplitude (RA) is derived from the difference between the
most active 10-hour period (M10) and the least active 5-hour period (L5).
}
