% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrangle_dat.R
\name{clean_odddat_optimus}
\alias{clean_odddat_optimus}
\alias{clean_even_dat}
\title{DAT file wrangler.}
\usage{
clean_odddat_optimus(df)

clean_even_dat(df)
}
\arguments{
\item{df}{df}
}
\value{
A clean data frame with clean NA values retained.

df
}
\description{
The function takes the dirty data frame obtained from reading the FLUOstar DAT file, applies an original
algorithm that inserts NAs in place of the special characters, and then applies a function called
comma_cleaner() to the dirty data frame for the removal of commas, and finally, rows with NAs only are removed.
}
\examples{
\dontrun{
fpath <- system.file("extdata", "dat_1.dat", package = "normfluodbf", mustWork = TRUE)
dat_df <- read.table(file=fpath)
partial_cleaned_dat <- clean_odddat_optimus(dat_df)}
\dontrun{clean_even_dat(df)}
}
\author{
Tingwei Adeck
}
