% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo_lite_sf.R
\name{geo_lite_sf}
\alias{geo_lite_sf}
\title{Address search API in \CRANpkg{sf} format (free-form query)}
\usage{
geo_lite_sf(
  address,
  limit = 1,
  return_addresses = TRUE,
  full_results = FALSE,
  verbose = FALSE,
  progressbar = TRUE,
  nominatim_server = "https://nominatim.openstreetmap.org/",
  custom_query = list(),
  points_only = TRUE
)
}
\arguments{
\item{address}{\code{character} with single line address, e.g.
(\code{"1600 Pennsylvania Ave NW, Washington"}) or a vector of addresses
(\code{c("Madrid", "Barcelona")}).}

\item{limit}{Maximum number of results to return per input address. Note
that each query returns a maximum of 50 results.}

\item{return_addresses}{Return input addresses with results if \code{TRUE}.}

\item{full_results}{Returns all available data from the API service.
If \code{FALSE} (default) only address columns are returned. See also
\code{return_addresses}.}

\item{verbose}{If \code{TRUE} then detailed logs are output to the console.}

\item{progressbar}{Logical. If \code{TRUE} displays a progress bar to indicate
the progress of the function.}

\item{nominatim_server}{The URL of the Nominatim server to use.
Defaults to \code{"https://nominatim.openstreetmap.org/"}.}

\item{custom_query}{A named list with API-specific parameters to be used
(i.e. \code{list(countrycodes = "US")}). See \strong{Details}.}

\item{points_only}{Logical \code{TRUE/FALSE}. Whether to return only spatial
points (\code{TRUE}, which is the default) or potentially other shapes as
provided by the Nominatim API (\code{FALSE}). See \strong{About Geometry Types}.}
}
\value{
A \code{\link[sf:sf]{sf}} object with the results.
}
\description{
This function allows you to geocode addresses and returns the corresponding
spatial object. This function returns the spatial object associated with the
query using \CRANpkg{sf}, see \code{\link[=geo_lite]{geo_lite()}} for retrieving the data in
\code{\link[tibble:tibble]{tibble}} format.

This function correspond to the \strong{free-form query} search described in the
\href{https://nominatim.org/release-docs/develop/api/Search/}{API endpoint}.
}
\details{
See \url{https://nominatim.org/release-docs/latest/api/Search/} for additional
parameters to be passed to \code{custom_query}.
}
\section{About Geometry Types}{


The parameter \code{points_only} specifies whether the function results will be
points (all Nominatim results are guaranteed to have at least point
geometry) or possibly other spatial objects.

Note that the type of geometry returned in case of \code{points_only = FALSE}
will depend on the object being geocoded:
\itemize{
\item Administrative areas, major buildings and the like will be
returned as polygons.
\item Rivers, roads and their like as lines.
\item Amenities may be points even in case of a \code{points_only = FALSE} call.
}

The function is vectorized, allowing for multiple addresses to be geocoded;
in case of \code{points_only = FALSE}  multiple geometry types may be returned.
}

\examples{
\dontshow{if (nominatim_check_access()) withAutoprint(\{ # examplesIf}
\donttest{
# Map - Points
library(ggplot2)

string <- "Statue of Liberty, NY, USA"
sol <- geo_lite_sf(string)

if (any(!sf::st_is_empty(sol))) {
  ggplot(sol) +
    geom_sf()
}

sol_poly <- geo_lite_sf(string, points_only = FALSE)

if (any(!sf::st_is_empty(sol_poly))) {
  ggplot(sol_poly) +
    geom_sf() +
    geom_sf(data = sol, color = "red")
}
# Several results

madrid <- geo_lite_sf("Comunidad de Madrid, Spain",
  limit = 2,
  points_only = FALSE, full_results = TRUE
)

if (any(!sf::st_is_empty(madrid))) {
  ggplot(madrid) +
    geom_sf(fill = NA)
}
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=geo_lite]{geo_lite()}}.

Geocoding:
\code{\link{geo_address_lookup}()},
\code{\link{geo_address_lookup_sf}()},
\code{\link{geo_amenity}()},
\code{\link{geo_amenity_sf}()},
\code{\link{geo_lite}()},
\code{\link{geo_lite_struct}()},
\code{\link{geo_lite_struct_sf}()}

Get \code{\link[sf:sf]{sf}} objects:
\code{\link{bbox_to_poly}()},
\code{\link{geo_address_lookup_sf}()},
\code{\link{geo_amenity_sf}()},
\code{\link{geo_lite_struct_sf}()},
\code{\link{reverse_geo_lite_sf}()}
}
\concept{geocoding}
\concept{spatial}
