% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_modelfit.R
\name{run_npd_3cmpt_oral}
\alias{run_npd_3cmpt_oral}
\title{Run and evaluate a three-compartment oral model}
\usage{
run_npd_3cmpt_oral(
  dat,
  est.method = "nls",
  input.ka = exp(1),
  input.cl = exp(1),
  input.vc3cmpt = exp(1),
  input.vp3cmpt = exp(1),
  input.vp23cmpt = exp(1),
  input.q3cmpt = exp(1),
  input.q23cmpt = exp(1),
  input.add = 1
)
}
\arguments{
\item{dat}{A data frame containing pharmacokinetic data in the standard
nlmixr2 format, including required columns such as \code{ID}, \code{EVID}, \code{DV}, and
\code{dose}.}

\item{est.method}{Estimation method used in nlmixr2. Defaults to "nls".}

\item{input.ka}{Initial estimate for the absorption rate constant (Ka).
Defaults to exp(1), corresponding to a log-scale value of 1.}

\item{input.cl}{Initial estimate for clearance (CL). Defaults to exp(1),
corresponding to a log-scale value of 1.}

\item{input.vc3cmpt}{Initial estimate for central volume of distribution (Vc).
Defaults to exp(1), corresponding to a log-scale value of 1.}

\item{input.vp3cmpt}{Initial estimate for first peripheral volume (Vp1).
Defaults to exp(1), corresponding to a log-scale value of 1.}

\item{input.vp23cmpt}{Initial estimate for second peripheral volume (Vp2).
Defaults to exp(1), corresponding to a log-scale value of 1.}

\item{input.q3cmpt}{Initial estimate for intercompartmental clearance Q1.
Defaults to exp(1), corresponding to a log-scale value of 1.}

\item{input.q23cmpt}{Initial estimate for intercompartmental clearance Q2.
Defaults to exp(1), corresponding to a log-scale value of 1.}

\item{input.add}{Additive error term. Defaults to 1.}
}
\value{
A list containing parameter estimates and prediction error metrics.
}
\description{
Fits a three-compartment oral pharmacokinetic model using a naive pooled data
approach and evaluates model performance using prediction error metrics.
}
\details{
Rows with \code{EVID == 2} are excluded prior to model fitting. The model is
fitted using \code{Fit_3cmpt_oral}, and prediction-based metrics are calculated to
assess model performance.
}
\examples{
\donttest{
run_npd_3cmpt_oral(
  dat = Oral_2CPT,
  input.cl = 4,
  input.vc3cmpt = 70,
  input.vp3cmpt = 40,
  input.vp23cmpt = 40,
  input.q3cmpt = 4,
  input.q23cmpt = 4
)
}

}
\seealso{
\code{\link{Fit_3cmpt_oral}}
}
\author{
Zhonghui Huang
}
