% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabu.cores.R
\name{is_move_tabu}
\alias{is_move_tabu}
\title{Check if a move is tabu}
\usage{
is_move_tabu(move, tabu_list, policy = c("attribute", "move"))
}
\arguments{
\item{move}{A list as returned by \code{\link{detect_move}},
containing \code{element}, \code{from}, and \code{to}.}

\item{tabu_list}{Data frame of tabu elements, with columns:
\code{elements} (variable name), \code{elements.value} (forbidden value),
and \code{tabu.iteration.left} (remaining tabu tenure).}

\item{policy}{Character scalar. Tabu restriction type:
\code{"attribute"} (default) or \code{"move"}.}
}
\value{
Logical scalar: TRUE if the move is tabu, FALSE otherwise.
}
\description{
Given a move (variable, from-value, to-value) and a tabu list,
this function checks whether the move is currently forbidden
by the tabu list.
}
\examples{
move <- list(element = "no.cmpt", from = 2, to = 3)
tabu_list <- data.frame(
  elements = c("no.cmpt", "eta.vc"),
  elements.value = c(3, 1),
  tabu.iteration.left = c(2, 1)
)
is_move_tabu(move, tabu_list)

}
\author{
Zhonghui Huang
}
