% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelGen.R
\name{initialize_param_table}
\alias{initialize_param_table}
\title{Generate initial parameter table for pharmacometric model estimation}
\usage{
initialize_param_table()
}
\value{
A data.frame with 29 columns containing parameter specifications. The structure includes:
\describe{
\item{Name}{Parameter name (e.g., "lcl", "eta.vc", "cor.eta_cl_vc")}
\item{init}{Numeric initial value for parameter estimation}
\item{lb}{Lower bound constraint (use -Inf for unconstrained)}
\item{ub}{Upper bound constraint (use Inf for unconstrained)}
\item{fixed}{Integer flag indicating whether parameter should be fixed (1) or estimated (0)}
\item{Description}{Text description of parameter's biological/pharmacometric meaning}
}
}
\description{
Creates a structured parameter table containing initial estimates with constraints for
base parameters, inter-individual variability (ETA), residual errors (SIGMA), and
correlation terms (OMEGA) to initialize nonlinear mixed-effects model fitting.
}
\details{
This table includes:
\itemize{
\item Base PK parameters (absorption, clearance, volumes, etc.) in log-scale
\item Michaelis-Menten kinetics parameters (vmax, km)
\item Absorption parameters including zero-order, mixed-order, and transit compartment models
\item Residual variability components (additive and proportional error)
\item Inter-individual variability (ETA) terms with variance parameters
\item Correlation parameters between ETA terms in two blocks:
\itemize{
\item Block 1: vmax and km parameters
\item Block 2: clearance, volumes, and inter-compartmental clearance
}
}

Parameters are organized with:
\itemize{
\item Name: Parameter name following standard nomenclature
\item init: Initial estimate for model fitting
\item lb/ub: Lower/upper bounds for parameter estimation
\item fixed: Flag indicating fixed parameters (1) vs estimated (0)
\item Description: Plain-text explanation of parameter meaning
}
}
\examples{
# Generate default parameter table
initialize_param_table()

}
\author{
Zhonghui Huang
}
