% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runNestedApprox.R
\name{sampleLatents}
\alias{sampleLatents}
\title{Sample from the posterior distribution of the latent nodes}
\usage{
sampleLatents(summary, n = 1000, includeParams = FALSE)
}
\arguments{
\item{summary}{an approxSummary object, returned by \code{runNestedApprox}.}

\item{n}{Number of samples to draw (default: 1000).}

\item{includeParams}{logical; if \code{TRUE}, include parameter values corresponding to each sample. 
Default is \code{FALSE}.}
}
\value{
Matrix of latent samples.
}
\description{
Draws samples from the posterior distribution of the latent nodes. 
Optionally includes parameter values corresponding to each sample.
}
\details{
The sampling approach uses stratified sampling from a weighted mixture of multivariate normals, 
where the weights are based on the
approximate marginal density at each grid point in the parameter grid. For each point, the multivariate normal
is based on Laplace approximation, using the maximum for the mean and the inverse Hessian for the covariance
matrix. This approach is not valid for sparse AGHQ due to negative quadrature weights. This can be updated by
\code{setParamGrid} and any quadrature rule other than \code{AGHQSPARSE}.

The parameter values corresponding to the samples can be requested via \code{includeParams}.

Note that NIMBLE's nested approximation framework does not provide marginals for the latent nodes
based on analytic approximation, so both joint and univariate inference on the latent nodes
is from sampling.

See \code{runNestedApprox} for example usage.
}
