% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resample_to.R
\name{resample_to}
\alias{resample_to}
\title{Resample an image with readable method names}
\usage{
resample_to(
  source,
  target,
  method = c("nearest", "linear", "cubic"),
  engine = c("internal"),
  ...
)
}
\arguments{
\item{source}{A `NeuroVol` (source image)}

\item{target}{A `NeuroVol` or `NeuroSpace` to match}

\item{method}{Interpolation method: `"nearest"`, `"linear"`, or `"cubic"`}

\item{engine}{Resampling engine. For now only `"internal"` is supported.}

\item{...}{Reserved for future options}
}
\value{
A `NeuroVol` in the target space
}
\description{
A convenience front-end to [resample()] that accepts human-friendly
method names and an engine switch. Internally delegates to the S4
`resample(source, target, interpolation = 0/1/3)` methods.
}
\examples{
\donttest{
img <- read_vol(system.file("extdata","global_mask_v4.nii", package="neuroim2"))
sp  <- space(img)
sp2 <- NeuroSpace(sp@dim*2, sp@spacing/2, origin=sp@origin, trans=trans(img))
r1  <- resample_to(img, sp2, method = "linear")
}
}
