% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/neurospace.R
\name{bounds}
\alias{bounds}
\alias{bounds,NeuroSpace-method}
\title{Extract Spatial Bounds of an Image}
\usage{
bounds(x)

\S4method{bounds}{NeuroSpace}(x)
}
\arguments{
\item{x}{The object with the `bounds` property, typically an image.}
}
\value{
A numeric \code{matrix} with two columns specifying the min (column 1) and max (column 2) bounds of each dimension of \code{x}.
}
\description{
This function extracts the spatial bounds (origin + dim * spacing) of an image represented by the input object.
}
\examples{
bspace <- NeuroSpace(c(10, 10, 10), c(2, 2, 2))
b <- bounds(bspace)
nrow(b) == ndim(bspace)
ncol(b) == 2

}
