# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Returns the EM object for unilayer network
#'
#' @param x multiple network
#' @param K number of clusters
#' @param eps epsilon for convergence
#' @param num_rand_start number of random starts
#' @param num_run_smallEM number of runs for small EM
#' @param max_itr_smallEM maximum number of runs for small EM
#' @param burn number of runs for burn for Metropolis Hastings
#' @param MCMC_itr number of runs for Metropolis Hastings iterations
#' @param sigma_mult scaling multiplier for Sigma matrix
#' @param alpha seed provided by the user
#' @return EM object
#' @export
netEM_unilayer <- function(x, K, eps, num_rand_start, num_run_smallEM, max_itr_smallEM, burn, MCMC_itr, sigma_mult, alpha) {
    .Call(`_netClust_netEM_unilayer`, x, K, eps, num_rand_start, num_run_smallEM, max_itr_smallEM, burn, MCMC_itr, sigma_mult, alpha)
}

#' Returns the EM object for multilayer network
#'
#' @param y multiple network
#' @param K number of clusters
#' @param p number of layers
#' @param eps epsilon for convergence
#' @param num_rand_start number of random starts
#' @param num_run_smallEM number of runs for small EM
#' @param max_itr_smallEM maximum number of runs for small EM
#' @param burn number of runs for burn for Metropolis Hastings
#' @param MCMC_itr number of runs for Metropolis Hastings iterations
#' @param sigma_mult scaling multiplier for Sigma matrix
#' @param psi_mult scaling multiplier for Psi matrix
#' @param n number of nodes of the network
#' @param alpha seed provided by the user
#' @return EM object
#' @export
netEM_multilayer <- function(y, K, p, eps, num_rand_start, num_run_smallEM, max_itr_smallEM, burn, MCMC_itr, sigma_mult, psi_mult, n, alpha) {
    .Call(`_netClust_netEM_multilayer`, y, K, p, eps, num_rand_start, num_run_smallEM, max_itr_smallEM, burn, MCMC_itr, sigma_mult, psi_mult, n, alpha)
}

rcpparma_hello_world <- function() {
    .Call(`_netClust_rcpparma_hello_world`)
}

rcpparma_outerproduct <- function(x) {
    .Call(`_netClust_rcpparma_outerproduct`, x)
}

rcpparma_innerproduct <- function(x) {
    .Call(`_netClust_rcpparma_innerproduct`, x)
}

rcpparma_bothproducts <- function(x) {
    .Call(`_netClust_rcpparma_bothproducts`, x)
}

