% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dates.R
\name{ndate}
\alias{ndate}
\title{neat representation of dates}
\usage{
ndate(
  date,
  show_weekday = TRUE,
  show_month_year = FALSE,
  display_weekday = NULL,
  is_month = NULL
)
}
\arguments{
\item{date}{a Date or POSIX time stamp}

\item{show_weekday}{a Boolean. Whether the weekday of the date
to be included.}

\item{show_month_year}{a Boolean variable representing if the date
represents month. If this set to TRUE,
the function returns 'MMMM'YY' as the output which is a neater
representation of month.}

\item{display_weekday}{Deprecated. Use 'show_weekday' instead.}

\item{is_month}{Deprecated. Use 'show_month_year' instead.}
}
\value{
String representation of the date
}
\description{
neat representation of dates
}
\examples{
# Neat representation of current date
x <- Sys.Date()
ndate(x)
# Neat representation of current date with day of week.
ndate(x, show_weekday = FALSE)
# Neat representation of current date with only month and year
ndate(x, show_weekday = FALSE, show_month_year = TRUE)
}
