% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/super_learner_helpers.R
\name{make_learner_names_unique}
\alias{make_learner_names_unique}
\title{Make Unique Learner Names}
\usage{
make_learner_names_unique(learners)
}
\arguments{
\item{learners}{A list of learners. See \code{?learners}}
}
\value{
A list of learners with (possibly) improved names.
}
\description{
Make Unique Learner Names
}
\examples{
learners <-
  list(
    mean = lnr_mean,
    rf = lnr_rf,
    rf = lnr_rf,
    lnr_glm,
    lnr_xgboost,
    function(data, formula) {},
    function(data, formula) {})
learners <- nadir::make_learner_names_unique(learners)
names(learners)

learners <-
  list(
    lnr_mean,
    lnr_rf,
    lnr_rf,
    lnr_glm,
    lnr_xgboost,
    function(data, formula) {},
    function(data, formula) {})
learners <- nadir::make_learner_names_unique(learners)
names(learners)

}
