# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

cpp_nullTXIs <- function(count_matrix, strata_vector, num_permutations) {
    .Call(`_myTAI_cpp_nullTXIs`, count_matrix, strata_vector, num_permutations)
}

#' @title Calculate TXI for Single-Cell Expression Data (C++ Implementation)
#' @description Efficiently calculate TXI values for sparse single-cell expression matrices
#' using batch processing and parallel computation.
#' 
#' @param expression Sparse expression matrix (genes x cells) - dgCMatrix format
#' @param strata_values Numeric vector of phylostratum values for each gene
#' @param batch_size Integer, number of cells to process per batch (default: 2000)
#' @param ncores Integer, number of cores to use for parallel processing (default: 10, automatically capped at available cores)
#' @return Numeric vector of TXI values for each cell
#' 
#' @details
#' This function processes large sparse single-cell expression matrices efficiently by:
#' - Splitting cells into batches to manage memory usage
#' - Using parallel processing across batches
#' - Leveraging sparse matrix operations to skip zero entries
#' - Handling cells with zero expression by returning NA
#' 
#' @author Kristian K Ullrich
#' @keywords internal
cpp_txi_sc <- function(expression, strata_values, batch_size = 2000L, ncores = 10L) {
    .Call(`_myTAI_cpp_txi_sc`, expression, strata_values, batch_size, ncores)
}

