% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_mfpca.R
\name{run_mfpca}
\alias{run_mfpca}
\title{run_fpca}
\usage{
run_mfpca(
  mxFDAobject,
  metric = "uni k",
  r = "r",
  value = "fundiff",
  knots = NULL,
  lightweight = FALSE,
  ...
)
}
\arguments{
\item{mxFDAobject}{object of class \code{mxFDA} created by \code{\link[=make_mxfda]{make_mxfda()}} with metrics derived with \code{\link[=extract_summary_functions]{extract_summary_functions()}}}

\item{metric}{name of calculated spatial metric to use}

\item{r}{Character string, the name of the variable that identifies the function domain (usually a radius for spatial summary functions). Default is "r".}

\item{value}{Character string, the name of the variable that identifies the spatial summary function values. Default is "fundiff".}

\item{knots}{Number of knots for defining spline basis.Defaults to the number of measurements per function divided by 2.}

\item{lightweight}{Default is FALSE. If TRUE, removes Y and Yhat from returned mFPCA object. A good option to select for large datasets.}

\item{...}{Optional other arguments to be passed to \code{mfpca.face}}
}
\value{
A \code{mxFDA} object  with the \code{functional_mpca} slot for the respective spatial summary function containing:
\item{mxfundata}{The original dataframe of spatial summary functions, with scores from FPCA appended for downstream modeling}
\item{fpc_object}{A list of class "fpca" with elements described in the documentation for  \code{refund::fpca.face}}
}
\description{
This is a wrapper for the function \code{mfpca.face} from the \code{refund} package. EXPAND
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\examples{
#load data
data(lung_FDA)

#run mixed fpca
lung_FDA = run_mfpca(lung_FDA, metric = 'uni g')

}
\references{
Xiao, L., Ruppert, D., Zipunnikov, V., and Crainiceanu, C. (2016).
Fast covariance estimation for high-dimensional functional data.
\emph{Statistics and Computing}, 26, 409-421.
DOI: 10.1007/s11222-014-9485-x.
}
\author{
unknown \email{first.last@domain.extension}

Julia Wrobel \email{julia.wrobel@emory.edu}

Alex Soupir \email{alex.soupir@moffitt.org}
}
