% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wellformedness.R
\name{clampitt_q}
\alias{clampitt_q}
\title{Voice leadings between inversions with maximal common tones}
\usage{
clampitt_q(
  set,
  index = NULL,
  method = c("taxicab", "euclidean", "chebyshev", "hamming"),
  edo = 12,
  rounder = 10
)
}
\arguments{
\item{set}{Numeric vector of pitch-classes in the set}

\item{index}{Integer: which Q-related set and voice leading should be returned? Defaults to \code{NULL},
in which case all options are returned.}

\item{method}{What distance metric should be used? Defaults to \code{"taxicab"}
but can be \code{"euclidean"}, \code{"chebyshev"}, or \code{"hamming"}.}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}

\item{rounder}{Numeric (expected integer), defaults to \code{10}:
number of decimal places to round to when testing for equality.}
}
\value{
A list with two entries, \code{"sets"} and \code{"vls"}. The former is a matrix whose columns are
the sets which are Q-related to the input \code{set}, in OPC-normal form. The latter is a matrix
whose rows represent the voice-leading motions which transform \code{set} into its goals.
(This follows the general practice of musicMCT of representing scales as columns and
voice leadings as rows.) The rows
of \code{"vls"} correspond to the columns of \code{"sets"}, but the columns of \code{"vls"} correspond to the order
of the input \code{set}, which may not match the normal form of the output \code{sets}. (See the last example.)
}
\description{
Clampitt (2007, 467; \doi{doi:10.1007/978-3-642-04579-0_46}) defines two \eqn{n}-note sets to be Q-related
if they:
\itemize{
\item Have all but one tone in common
\item Are related by \code{\link[=tni]{tni()}}
\item Have a strictly crossing-free voice leading which preserves all \eqn{n-1} common tones
This function finds all sets which are Q-related to an input \code{set} in this sense. The relation
is defined to generalize the smooth voice leadings between consonant triads and diatonic scales
to other sets, in particular demonstrating that non-singular pairwise well-formed scales (see \code{\link[=isgwf]{isgwf()}})
demonstrate similarly nice voice leading properties.
}

(Strictly speaking, Clampitt includes \code{\link[=tn]{tn()}} in the second part of the definition. However, the first
criterion is only possible under \code{\link[=tn]{tn()}} if the set is generated and therefore inversionally symmetrical.
Therefore if a set satisfies Clampitt's definition by \code{\link[=tn]{tn()}}, it also satisfies the \code{\link[=tni]{tni()}} requirement.)

If the third part of the definition is relaxed, allowing the voice leading to involve voice crossing,
Clampitt (1997, 121) identifies this as the Q*-relation. The Q*-relation can be computed
with this function by setting \code{method="hamming"}. (All other methods provided by \code{\link[=vl_dist]{vl_dist()}} give
equivalent results in this context.)
}
\examples{
# The Neo-Riemannian P, L, and R transformations on triads are all Q-relations:
major_triad <- c(0, 4, 7)
clampitt_q(major_triad)

# A well-formed scale like the diatonic has two Q-relations given by its signature transformations:
major_scale <- c(0, 2, 4, 5, 7, 9, 11)
clampitt_q(major_scale)

# A non-singular pairwise well-formed scale also has Q-relations:
clampitt_q(j(dia))

# Set-class 7-31 is pairwise well-formed:
clampitt_q(sc(7, 31))
# It also has two additional Q*-related sets:
clampitt_q(sc(7, 31), method="hamming")

# Most other types of scales have at most one Q-relation:
dominant_seventh <- c(0, 4, 7, 10)
clampitt_q(dominant_seventh)

# The order of "sets" may not match the order of "vls":
clampitt_q(c(0, 1, 4, 7))

}
\seealso{
\code{\link[=isgwf]{isgwf()}}, \code{\link[=minimize_vl]{minimize_vl()}}, \code{\link[=normal_form]{normal_form()}}
}
