% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/like.R
\name{like_comp}
\alias{like_comp}
\title{Likelihood for composition vectors}
\usage{
like_comp(
  obs,
  pred,
  type = c("multinomial", "dirmult1", "dirmult2", "lognormal"),
  N = sum(obs),
  theta,
  stdev
)
}
\arguments{
\item{obs}{A vector of observed values. Internally converted to proportions.}

\item{pred}{A vector of predicted values. Same length as \code{obs}. Internally converted to proportions.}

\item{type}{Character for the desired distribution}

\item{N}{Numeric, the sample size corresponding to \code{obs} for multinomial or Dirichlet multinomial distributions.}

\item{theta}{Numeric, the linear (\code{type = "dirmult1"}) or saturating (\code{type = "dirmult2"}) Dirichlet-multinomial parameter, respectively. See Thorson et al. (2017)}

\item{stdev}{Numeric or vectorized for \code{obs}, the likelihood standard deviation for lognormal distribution.}
}
\value{
Numeric representing the log-likelihood.
}
\description{
Returns the log-likelihood for composition data, e.g., length, age, or stock composition,
with various statistical distributions supported.
}
\details{
Observed and predicted vectors are internally converted to proportions.

For \code{type = "lognormal"}, zero observations are removed from the likelihood calculation.
}
\examples{
M <- 0.1
age <- seq(1:10)
pred <- exp(-M * age)
obs <- pred * rlnorm(10, sd = 0.05)
like_comp(obs, pred, N = 10, type = "multinomial")
like_comp(obs, pred, N = 100, type = "multinomial")
like_comp(obs, pred, N = 10, type = "dirmult1", theta = 1)
like_comp(obs, pred, N = 10, type = "dirmult1", theta = 20)
}
\references{
Thorson et al. 2017. Model-based estimates of effective sample size in stock assessment models using the
Dirichlet-multinomial distribution. Fish. Res. 192:84-93. \doi{10.1016/j.fishres.2016.06.005}
}
