% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_int.R
\name{calc_index}
\alias{calc_index}
\title{Calculate index at age}
\usage{
calc_index(
  N,
  Z,
  sel,
  na = dim(N)[1],
  nr = dim(N)[2],
  ns = dim(N)[3],
  ni = dim(sel)[2],
  samp = array(1, c(ni, nr, ns)),
  delta = rep(0, ni)
)
}
\arguments{
\item{N}{Stock abundance at the beginning of the time step. Array \verb{[a, r, s]}}

\item{Z}{Instantaneous total mortality. Array \verb{[a, r, s]}}

\item{sel}{Index selectivity. Array \verb{[a, i, s]}}

\item{na}{Integer, number of age classes}

\item{nr}{Integer, number of regions}

\item{ns}{Integer, number of stocks}

\item{ni}{Integer, number of indices}

\item{samp}{Boolean indicates which regions and stocks are sampled by the index. Array \verb{[i, r, s]}}

\item{delta}{Fraction of time step when the index samples the population. Vector by \code{i}. Set to a negative number (-1) to sample the average
population over the course of the time step, i.e. \code{N * (1 - exp(-Z))/Z}.}
}
\value{
Index at age. Array \verb{[a, i, s]}
}
\description{
For indices of abundance, the function calculates the numbers vulnerable to the survey.
}
\details{
The index is calculated as
\deqn{
I_{a,i,s} = v_{a,i,s} \sum_r N_{a,r,s} d_{a,r,s} \times \mathbb{1}(r \in R_i) \mathbb{1}(s \in S_i)
}

If the survey samples at a moment in time, then
\deqn{
d_{a,r,s} = \exp(-\delta_i Z_{a,r,s})
}

Otherwise, if the index samples the population over the duration of the time step, then
\deqn{
d_{a,r,s} = (1 - \exp(-Z_{a,r,s}))/Z_{a,r,s}
}

where \eqn{R_i} and \eqn{S_i} denote the regions and stocks, respectively, sampled by index \eqn{i}. For example,
\eqn{R_2 = 1} denotes that the second index of abundance only samples region 1. These are informed by array \code{samp} where
\code{samp[i, r, s] = 1} indicates that stock \code{s} in region \code{r} is sampled by index \code{i}.
}
