% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_rast.R
\name{to_rast.sim_com_results}
\alias{to_rast.sim_com_results}
\title{Convert \code{sim_com_results} to SpatRaster(s)}
\usage{
\method{to_rast}{sim_com_results}(
  obj,
  species = seq_len(dim(obj$N_map)[4]),
  time_points = obj$sim_time,
  ...
)
}
\arguments{
\item{obj}{An object of class \code{sim_com_results}, returned by \code{\link[=sim_com]{sim_com()}}.}

\item{species}{Integer vector. Species ID(s) to extract.}

\item{time_points}{Integer vector. Time step(s) to extract (excluding burn-in).}

\item{...}{Currently unused.}
}
\value{
\itemize{
\item If \code{length(time_points) == 1}, returns a \code{SpatRaster} with species as layers.
\item If \code{length(time_points) > 1}, returns a named list of \code{SpatRaster} objects, one per species.
\item If only one species is selected with multiple time points, returns a single \code{SpatRaster}.
}
}
\description{
Converts simulated population abundance data from a \code{sim_com_results} object
(produced by \code{\link[=sim_com]{sim_com()}}) into \code{\link[terra:SpatRaster-class]{SpatRaster}} objects.
}
\examples{

# Read simulation data from the mrangr package
simulated_com <- get_simulated_com()

# Extract one timestep, all species
r1 <- to_rast(simulated_com, time_points = 10)

# Extract multiple timesteps, one species
r2 <- to_rast(simulated_com, species = 2, time_points = c(1, 5, 10))

# Extract multiple timesteps, multiple species
r3 <- to_rast(simulated_com, species = c(1, 2), time_points = c(1, 5, 10))


}
